/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl;

import java.util.Set;
import net.sf.ehcache.CacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.OnePerKindCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.OnePerKindKeyProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableIdSourceKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableKeyProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableIdSourceKey;
import org.hibernate.ogm.datastore.keyvalue.options.CacheMappingType;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class PersistenceStrategy<EK, AK, ISK> {
    private final LocalCacheManager<EK, AK, ISK> cacheManager;
    private final KeyProvider<EK, AK, ISK> keyProvider;

    private PersistenceStrategy(LocalCacheManager<EK, AK, ISK> cacheManager, KeyProvider<EK, AK, ISK> keyProvider) {
        this.cacheManager = cacheManager;
        this.keyProvider = keyProvider;
    }

    public static PersistenceStrategy<?, ?, ?> getInstance(CacheMappingType cacheMapping, CacheManager externalCacheManager, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        if (cacheMapping == CacheMappingType.CACHE_PER_KIND) {
            return PersistenceStrategy.getPerKindStrategy(externalCacheManager);
        }
        return PersistenceStrategy.getPerTableStrategy(externalCacheManager, entityTypes, associationTypes, idSourceTypes);
    }

    private static PersistenceStrategy<?, ?, ?> getPerKindStrategy(CacheManager externalCacheManager) {
        OnePerKindKeyProvider keyProvider = new OnePerKindKeyProvider();
        OnePerKindCacheManager cacheManager = new OnePerKindCacheManager(externalCacheManager);
        return new PersistenceStrategy<SerializableEntityKey, SerializableAssociationKey, SerializableIdSourceKey>(cacheManager, keyProvider);
    }

    private static PersistenceStrategy<?, ?, ?> getPerTableStrategy(CacheManager externalCacheManager, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        PerTableKeyProvider keyProvider = new PerTableKeyProvider();
        PerTableCacheManager cacheManager = new PerTableCacheManager(externalCacheManager, entityTypes, associationTypes, idSourceTypes);
        return new PersistenceStrategy<PerTableSerializableEntityKey, PerTableSerializableAssociationKey, PerTableSerializableIdSourceKey>(cacheManager, keyProvider);
    }

    public LocalCacheManager<EK, AK, ISK> getCacheManager() {
        return this.cacheManager;
    }

    public KeyProvider<EK, AK, ISK> getKeyProvider() {
        return this.keyProvider;
    }
}

