/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.cfg.Configuration;
import org.hibernate.ogm.massindex.impl.OgmMassIndexerFactory;
import org.hibernate.search.query.DatabaseRetrievalMethod;

public final class HibernateSearchIntegration {
    private static final boolean searchIsAvailable = HibernateSearchIntegration.isSearchAvailable();
    private static String MASSINDEXER_PROPERTY_KEY = null;
    private static String MASSINDEXER_PROPERTY_VALUE = null;
    private static String RETRIEVALSTRATEGY_PROPERTY_KEY = null;
    private static String RETRIEVALSTRATEGY_PROPERTY_VALUE = null;

    private HibernateSearchIntegration() {
    }

    private static boolean isSearchAvailable() {
        try {
            HibernateSearchIntegration.class.getClassLoader().loadClass("org.hibernate.search.cfg.Environment");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void resetProperties(Configuration ogmConfiguration) {
        if (searchIsAvailable) {
            ogmConfiguration.setProperty(MASSINDEXER_PROPERTY_KEY, MASSINDEXER_PROPERTY_VALUE);
            ogmConfiguration.setProperty(RETRIEVALSTRATEGY_PROPERTY_KEY, RETRIEVALSTRATEGY_PROPERTY_VALUE);
        }
    }

    public static void setPropertiesIfUndefined(Properties properties, Configuration ogmConfiguration) {
        if (searchIsAvailable) {
            if (!properties.containsKey(MASSINDEXER_PROPERTY_KEY)) {
                ogmConfiguration.setProperty(MASSINDEXER_PROPERTY_KEY, MASSINDEXER_PROPERTY_VALUE);
            }
            if (!properties.containsKey(RETRIEVALSTRATEGY_PROPERTY_KEY)) {
                ogmConfiguration.setProperty(RETRIEVALSTRATEGY_PROPERTY_KEY, RETRIEVALSTRATEGY_PROPERTY_VALUE);
            }
        }
    }

    public static void resetProperties(Map<Object, Object> map) {
        if (searchIsAvailable) {
            map.put(MASSINDEXER_PROPERTY_KEY, MASSINDEXER_PROPERTY_VALUE);
            map.put(RETRIEVALSTRATEGY_PROPERTY_KEY, RETRIEVALSTRATEGY_PROPERTY_VALUE);
        }
    }

    static {
        if (searchIsAvailable) {
            RETRIEVALSTRATEGY_PROPERTY_KEY = "hibernate.search.query.database_retrieval_method";
            RETRIEVALSTRATEGY_PROPERTY_VALUE = DatabaseRetrievalMethod.FIND_BY_ID.name();
            MASSINDEXER_PROPERTY_KEY = "hibernate.search.massindexer.factoryclass";
            MASSINDEXER_PROPERTY_VALUE = OgmMassIndexerFactory.class.getName();
        }
    }
}

