/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateProducer;
import org.hibernate.service.Service;

public class EventContextManager
implements Service {
    private final ThreadLocal<Map<Class<?>, Object>> stateHolder = new ThreadLocal();
    private final Map<Class<?>, EventStateProducer<?>> producers;

    public EventContextManager(Map<Class<?>, EventStateProducer<?>> producers) {
        this.producers = Collections.unmodifiableMap(producers);
    }

    void onEventBegin(EventSource session) {
        HashMap<Class<SessionImplementor>, EventSource> stateMap = new HashMap<Class<SessionImplementor>, EventSource>();
        stateMap.put(SessionImplementor.class, session);
        this.stateHolder.set(stateMap);
    }

    void onEventFinished() {
        this.stateHolder.remove();
    }

    public <T> T get(Class<T> stateType) {
        Object value = this.getStates().get(stateType);
        if (value == null) {
            value = this.create(stateType);
            this.getStates().put(stateType, value);
        }
        return (T)value;
    }

    private <T> T create(Class<T> stateType) {
        EventStateProducer<?> producer = this.producers.get(stateType);
        if (producer == null) {
            throw new IllegalStateException("No producer found for state type: " + stateType);
        }
        SessionImplementor session = (SessionImplementor)this.stateHolder.get().get(SessionImplementor.class);
        return (T)producer.produce(session);
    }

    private Map<Class<?>, Object> getStates() {
        Map<Class<?>, Object> states = this.stateHolder.get();
        if (states == null) {
            throw new IllegalStateException("Must not access event cycle state if not within a supported event cycle (flush, auto-flush, persist)");
        }
        return states;
    }
}

