/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.spi.PersistEvent;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.jpa.event.internal.core.JpaPersistEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;

public class EventContextManagingPersistEventListener
implements PersistEventListener {
    private PersistEventListener delegate;
    private final EventContextManager stateManager;

    public EventContextManagingPersistEventListener(EventContextManager stateManager) {
        this.stateManager = stateManager;
    }

    public void setDelegate(PersistEventListener delegate) {
        this.delegate = delegate;
    }

    public void onPersist(PersistEvent event) throws HibernateException {
        this.stateManager.onEventBegin(event.getSession());
        try {
            this.delegate.onPersist(event);
        }
        finally {
            this.stateManager.onEventFinished();
        }
    }

    public void onPersist(PersistEvent event, Map createdAlready) throws HibernateException {
        this.stateManager.onEventBegin(event.getSession());
        try {
            this.delegate.onPersist(event, createdAlready);
        }
        finally {
            this.stateManager.onEventFinished();
        }
    }

    public static class EventContextManagingPersistEventListenerDuplicationStrategy
    implements DuplicationStrategy {
        public static final DuplicationStrategy INSTANCE = new EventContextManagingPersistEventListenerDuplicationStrategy();

        private EventContextManagingPersistEventListenerDuplicationStrategy() {
        }

        public boolean areMatch(Object listener, Object original) {
            if (listener instanceof EventContextManagingPersistEventListener && original instanceof JpaPersistEventListener) {
                ((EventContextManagingPersistEventListener)listener).setDelegate((PersistEventListener)((JpaPersistEventListener)original));
                return true;
            }
            return false;
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.REPLACE_ORIGINAL;
        }
    }
}

