/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.eventstate.impl;

import java.util.Collections;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.dialect.eventstate.impl.EventStateProducer;
import org.hibernate.ogm.failure.impl.OperationCollector;
import org.hibernate.ogm.transaction.impl.ErrorHandlerEnabledTransactionDecorator;

public class EventStateProducers {
    private EventStateProducers() {
    }

    public static Map<Class<?>, EventStateProducer<?>> getProducers(Map<?, ?> configuration) {
        if (configuration.containsKey("hibernate.ogm.error_handler")) {
            return Collections.singletonMap(OperationCollector.class, OperationCollectorProducer.INSTANCE);
        }
        return Collections.emptyMap();
    }

    private static class OperationCollectorProducer
    implements EventStateProducer<OperationCollector> {
        private static EventStateProducer<?> INSTANCE = new OperationCollectorProducer();

        private OperationCollectorProducer() {
        }

        @Override
        public OperationCollector produce(SessionImplementor session) {
            return ((ErrorHandlerEnabledTransactionDecorator)session.getTransactionCoordinator().getTransaction()).getOperationCollector();
        }
    }
}

