/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.failure.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.ogm.failure.ErrorHandler;
import org.hibernate.ogm.failure.ErrorHandlingStrategy;
import org.hibernate.ogm.failure.operation.GridDialectOperation;

public class OperationCollector
implements ErrorHandler.RollbackContext {
    private final ErrorHandler errorHandler;
    private final List<GridDialectOperation> appliedOperations;

    public OperationCollector(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.appliedOperations = new ArrayList<GridDialectOperation>();
    }

    public void addAppliedOperation(GridDialectOperation operation) {
        this.appliedOperations.add(operation);
    }

    public ErrorHandlingStrategy onFailedOperation(GridDialectOperation operation, Exception exception) {
        DefaultFailedOperationContext context = new DefaultFailedOperationContext(operation, exception);
        return this.errorHandler.onFailedGridDialectOperation(context);
    }

    public List<GridDialectOperation> getAppliedGridDialectOperations() {
        return Collections.unmodifiableList(this.appliedOperations);
    }

    private class DefaultFailedOperationContext
    implements ErrorHandler.FailedGridDialectOperationContext {
        private final GridDialectOperation failedOperation;
        private final Exception exception;

        DefaultFailedOperationContext(GridDialectOperation failedOperation, Exception exception) {
            this.failedOperation = failedOperation;
            this.exception = exception;
        }

        @Override
        public GridDialectOperation getFailedOperation() {
            return this.failedOperation;
        }

        public List<GridDialectOperation> getAppliedGridDialectOperations() {
            return Collections.unmodifiableList(OperationCollector.this.appliedOperations);
        }

        @Override
        public Exception getException() {
            return this.exception;
        }
    }
}

