/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.massindex.impl.BatchCoordinator;
import org.hibernate.ogm.massindex.impl.Executors;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchIntegrator;

public class OgmMassIndexer
implements MassIndexer {
    private static final Log log = LoggerFactory.make();
    private final ExtendedSearchIntegrator searchIntegrator;
    private final SessionFactoryImplementor sessionFactory;
    private final GridDialect gridDialect;
    private MassIndexerProgressMonitor monitor;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeOnFinish = true;
    private boolean optimizeAfterPurge = true;
    private boolean purgeAllOnStart = true;
    private int typesToIndexInParallel = 1;
    private final Set<Class<?>> rootEntities;

    public OgmMassIndexer(GridDialect gridDialect, SearchIntegrator searchFactory, SessionFactoryImplementor sessionFactory, Class<?> ... entities) {
        this.gridDialect = gridDialect;
        this.searchIntegrator = (ExtendedSearchIntegrator)searchFactory.unwrap(ExtendedSearchIntegrator.class);
        this.sessionFactory = sessionFactory;
        this.rootEntities = OgmMassIndexer.toRootEntities(this.searchIntegrator, entities);
        this.monitor = this.createMonitor(this.searchIntegrator);
    }

    private MassIndexerProgressMonitor createMonitor(ExtendedSearchIntegrator searchFactory) {
        return searchFactory.isJMXEnabled() ? new JMXRegistrar.IndexingProgressMonitor() : new SimpleIndexingProgressMonitor();
    }

    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        log.unsupportedIndexerConfigurationOption("threadsToLoadObjects");
        return this;
    }

    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        log.unsupportedIndexerConfigurationOption("batchSizeToLoadObjects");
        return this;
    }

    public MassIndexer threadsForSubsequentFetching(int numberOfThreads) {
        log.unsupportedIndexerConfigurationOption("threadForSubsequentFetching");
        return this;
    }

    public MassIndexer progressMonitor(MassIndexerProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public MassIndexer cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeOnFinish = optimize;
        return this;
    }

    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAllOnStart = purgeAll;
        return this;
    }

    public MassIndexer limitIndexedObjectsTo(long maximum) {
        log.unsupportedIndexerConfigurationOption("limitIndexedObjectsTo");
        return this;
    }

    public MassIndexer idFetchSize(int idFetchSize) {
        log.unsupportedIndexerConfigurationOption("idFetchSize");
        return this;
    }

    public MassIndexer typesToIndexInParallel(int threadsToIndexObjects) {
        this.atLeastOneValidation(threadsToIndexObjects);
        this.typesToIndexInParallel = Math.min(threadsToIndexObjects, this.rootEntities.size());
        return this;
    }

    public Future<?> start() {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool(1, "batch coordinator");
        try {
            Future<?> future = executor.submit(this.createCoordinator());
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.gridDialect, this.rootEntities, this.searchIntegrator, this.sessionFactory, this.typesToIndexInParallel, this.cacheMode, this.optimizeOnFinish, this.purgeAllOnStart, this.optimizeAfterPurge, this.monitor);
    }

    private void atLeastOneValidation(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
    }

    private static Set<Class<?>> toRootEntities(ExtendedSearchIntegrator searchFactoryImplementor, Class<?> ... selection) {
        HashSet entities = new HashSet();
        for (Class<?> entityType : selection) {
            Set targetedClasses = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
            if (targetedClasses.isEmpty()) {
                String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
                throw new IllegalArgumentException(msg);
            }
            entities.addAll(targetedClasses);
        }
        HashSet cleaned = new HashSet();
        HashSet<Class> toRemove = new HashSet<Class>();
        for (Class type : entities) {
            boolean typeIsOk = true;
            for (Class clazz : cleaned) {
                if (clazz.isAssignableFrom(type)) {
                    typeIsOk = false;
                    break;
                }
                if (!type.isAssignableFrom(clazz)) continue;
                toRemove.add(clazz);
            }
            if (!typeIsOk) continue;
            cleaned.add(type);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }
}

