/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.impl;

import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class DefaultIdSourceKeyMetadata
implements IdSourceKeyMetadata {
    private final IdSourceKeyMetadata.IdSourceType type;
    private final String name;
    private final String keyColumnName;
    private final String valueColumnName;
    private final int hashCode;

    private DefaultIdSourceKeyMetadata(IdSourceKeyMetadata.IdSourceType type, String name, String keyColumnName, String valueColumnName) {
        this.type = type;
        this.name = name;
        this.keyColumnName = keyColumnName;
        this.valueColumnName = valueColumnName;
        this.hashCode = this.calculateHashCode();
    }

    public static DefaultIdSourceKeyMetadata forTable(String table, String keyColumnName, String valueColumnName) {
        return new DefaultIdSourceKeyMetadata(IdSourceKeyMetadata.IdSourceType.TABLE, table, keyColumnName, valueColumnName);
    }

    public static DefaultIdSourceKeyMetadata forSequence(String sequence) {
        return new DefaultIdSourceKeyMetadata(IdSourceKeyMetadata.IdSourceType.SEQUENCE, sequence, null, null);
    }

    @Override
    public IdSourceKeyMetadata.IdSourceType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    @Override
    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultIdSourceKeyMetadata other = (DefaultIdSourceKeyMetadata)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "DefaultIdSourceKeyMetadata [type=" + (Object)((Object)this.type) + ", name=" + this.name + ", keyColumnName=" + this.keyColumnName + ", valueColumnName=" + this.valueColumnName + "]";
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }
}

