/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.parsing.impl;

import java.util.Iterator;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.StringHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.AssociationType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class ParserPropertyHelper
implements PropertyHelper {
    private final SessionFactoryImplementor sessionFactory;
    private final EntityNamesResolver entityNames;

    public ParserPropertyHelper(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames) {
        this.sessionFactory = sessionFactory;
        this.entityNames = entityNames;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Type propertyType = this.getPropertyType(entityType, propertyPath);
        if (propertyType.isEntityType()) {
            throw new UnsupportedOperationException("Queries on associated entities are not supported yet.");
        }
        if (propertyType instanceof AbstractStandardBasicType) {
            return ((AbstractStandardBasicType)propertyType).fromString(value);
        }
        return value;
    }

    protected Type getPropertyType(String entityType, List<String> propertyPath) {
        OgmCollectionPersister collectionPersister;
        Joinable associatedJoinable;
        Iterator<String> pathIterator = propertyPath.iterator();
        OgmEntityPersister persister = this.getPersister(entityType);
        String propertyName = pathIterator.next();
        Type propertyType = persister.getPropertyType(propertyName);
        if (!pathIterator.hasNext()) {
            return propertyType;
        }
        if (propertyType.isComponentType()) {
            return this.getComponentPropertyType(propertyType, pathIterator);
        }
        if (propertyType.isAssociationType() && (associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory())).isCollection() && (collectionPersister = (OgmCollectionPersister)associatedJoinable).getType().isComponentType()) {
            return this.getComponentPropertyType(collectionPersister.getType(), pathIterator);
        }
        throw new UnsupportedOperationException("Unrecognized property type: " + propertyType);
    }

    private Type getComponentPropertyType(Type type, Iterator<String> pathIterator) {
        if (pathIterator.hasNext()) {
            String property = pathIterator.next();
            Type subType = this.componentPropertyType((ComponentType)type, property);
            if (subType.isComponentType()) {
                return this.getComponentPropertyType(subType, pathIterator);
            }
            if (subType.isAssociationType()) {
                throw new UnsupportedOperationException("Queries on collection in embeddables are not supported: " + property);
            }
            return subType;
        }
        return type;
    }

    private Type componentPropertyType(ComponentType componentType, String property) {
        return componentType.getSubtypes()[componentType.getPropertyIndex(property)];
    }

    protected OgmEntityPersister getPersister(String entityType) {
        Class targetedType = this.entityNames.getClassFromName(entityType);
        if (targetedType == null) {
            throw new IllegalStateException("Unknown entity name " + entityType);
        }
        return (OgmEntityPersister)this.sessionFactory.getEntityPersister(targetedType.getName());
    }

    public boolean isEmbeddedProperty(String targetTypeName, PropertyPath propertyPath) {
        List namesWithoutAlias = propertyPath.getNodeNamesWithoutAlias();
        return this.isEmbeddedProperty(targetTypeName, namesWithoutAlias);
    }

    public boolean isEmbeddedProperty(String targetTypeName, List<String> namesWithoutAlias) {
        Joinable associatedJoinable;
        OgmEntityPersister persister = this.getPersister(targetTypeName);
        Type propertyType = persister.getPropertyType(namesWithoutAlias.get(0));
        if (propertyType.isComponentType()) {
            return true;
        }
        if (propertyType.isAssociationType() && (associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory())).isCollection()) {
            OgmCollectionPersister collectionPersister = (OgmCollectionPersister)associatedJoinable;
            return collectionPersister.getType().isComponentType();
        }
        return false;
    }

    protected String getColumn(OgmEntityPersister persister, List<String> propertyPath) {
        OgmCollectionPersister collectionPersister;
        Joinable associatedJoinable;
        Iterator<String> pathIterator = propertyPath.iterator();
        String propertyName = pathIterator.next();
        Type propertyType = persister.getPropertyType(propertyName);
        if (!pathIterator.hasNext()) {
            return persister.getPropertyColumnNames(propertyName)[0];
        }
        if (propertyType.isComponentType()) {
            String componentPropertyName = StringHelper.join(propertyPath, ".");
            return persister.getPropertyColumnNames(componentPropertyName)[0];
        }
        if (propertyType.isAssociationType() && (associatedJoinable = ((AssociationType)propertyType).getAssociatedJoinable(persister.getFactory())).isCollection() && (collectionPersister = (OgmCollectionPersister)associatedJoinable).getType().isComponentType()) {
            StringBuilder columnNameBuilder = new StringBuilder(propertyName);
            this.appendComponenCollectionPath(columnNameBuilder, collectionPersister, pathIterator);
            return columnNameBuilder.toString();
        }
        throw new UnsupportedOperationException("Unrecognized property type: " + propertyType);
    }

    private void appendComponenCollectionPath(StringBuilder columnNameBuilder, OgmCollectionPersister persister, Iterator<String> pathIterator) {
        if (pathIterator.hasNext()) {
            String property = pathIterator.next();
            Type subType = this.componentPropertyType((ComponentType)persister.getType(), property);
            if (subType.isComponentType()) {
                property = property + "." + StringHelper.join(pathIterator, ".");
            } else if (subType.isAssociationType()) {
                throw new UnsupportedOperationException("Queries on collection in embeddables are not supported: " + property);
            }
            columnNameBuilder.append(".");
            columnNameBuilder.append(persister.toColumns(property)[0]);
        }
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

