/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.nioneo.store.AbstractBaseRecord;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.InvalidRecordException;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.UnderlyingStorageException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class ProviderMeta
extends LifecycleAdapter {
    public static final String DEFAULT_NAME = "meta";
    public static final long ID_VERSION = 0L;
    static final int RECORD_SIZE = 9;
    private final FileSystemAbstraction fs;
    private final File file;
    private final ByteBuffer buffer = ByteBuffer.allocate(9);
    private StoreChannel channel;
    private int snapshotCount;
    private final PrimitiveLongObjectMap<Record> snapshotRecords = Primitive.longObjectMap();

    public ProviderMeta(FileSystemAbstraction fs, File file) {
        this.fs = fs;
        this.file = file;
    }

    @Override
    public synchronized void start() throws IOException {
        this.channel = this.fs.open(this.file, "rw");
    }

    @Override
    public synchronized void stop() throws IOException {
        this.updatePendingSnapshotChanges();
        this.channel.close();
        this.channel = null;
    }

    public synchronized Record getRecord(long id) throws InvalidRecordException {
        Record record;
        if (this.snapshotCount > 0 && (record = (Record)this.snapshotRecords.get(id)) != null) {
            return record;
        }
        try {
            boolean inUse;
            this.channel.position(id * 9L);
            this.buffer.clear();
            int bytesRead = this.channel.read(this.buffer);
            this.buffer.flip();
            if (bytesRead == -1) {
                throw new InvalidRecordException("No such record " + id);
            }
            if (bytesRead != 9) {
                throw new Error("Urgh");
            }
            byte inUseByte = this.buffer.get();
            boolean bl = inUse = inUseByte == 1;
            if (!inUse) {
                throw new InvalidRecordException("Record " + id + " not in use");
            }
            long value = this.buffer.getLong();
            Record record2 = new Record(id, value);
            record2.setInUse(true);
            return record2;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Error reading channel", e);
        }
    }

    public synchronized void updateRecord(Record record) {
        if (this.snapshotCount > 0) {
            this.snapshotRecords.put(record.getLongId(), (Object)record);
            return;
        }
        this.buffer.clear();
        this.buffer.put((byte)(record.inUse() ? 1 : 0));
        this.buffer.putLong(record.getValue());
        this.buffer.flip();
        try {
            this.channel.position(record.getLongId() * 9L);
            this.channel.write(this.buffer);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Error writing channel", e);
        }
    }

    public void force() {
        try {
            this.channel.force(true);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Error forcing channel", e);
        }
    }

    public synchronized Snapshot snapshot() {
        ++this.snapshotCount;
        if (this.snapshotCount == 1) {
            this.force();
        }
        return new Snapshot();
    }

    private synchronized void releaseSnapshot(Snapshot snapshot) {
        --this.snapshotCount;
        if (this.snapshotCount == 0) {
            this.updatePendingSnapshotChanges();
        }
    }

    private void updatePendingSnapshotChanges() {
        this.snapshotRecords.visitEntries((PrimitiveLongObjectVisitor)new PrimitiveLongObjectVisitor<Record>(){

            public void visited(long key, Record value) {
                ProviderMeta.this.updateRecord(value);
            }
        });
    }

    public class Snapshot
    implements Resource {
        private boolean closed;

        public File getFile() {
            return ProviderMeta.this.file;
        }

        @Override
        public void close() {
            if (!this.closed) {
                ProviderMeta.this.releaseSnapshot(this);
                this.closed = true;
            }
        }
    }

    public static class Record
    extends AbstractBaseRecord {
        private final long id;
        private long value;

        public Record(long id, long value) {
            this.id = id;
            this.value = value;
            this.setInUse(true);
        }

        @Override
        public long getLongId() {
            return this.id;
        }

        public void setValue(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value;
        }
    }
}

