/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;

public class HeapLongArray
implements LongArray {
    private final long[][] shards;
    private final long length;

    public HeapLongArray(long length) {
        this.length = length;
        int numShards = (int)((length - 1L) / Integer.MAX_VALUE) + 1;
        this.shards = new long[numShards][];
        for (int i = 0; i < numShards - 1; ++i) {
            this.shards[i] = new long[Integer.MAX_VALUE];
        }
        this.shards[numShards - 1] = new long[(int)(length % Integer.MAX_VALUE)];
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long get(long index) {
        return this.shard(index)[this.arrayIndex(index)];
    }

    @Override
    public void set(long index, long value) {
        this.shard((long)index)[this.arrayIndex((long)index)] = value;
    }

    private long[] shard(long index) {
        return this.shards[this.shardIndex(index)];
    }

    @Override
    public void setAll(long value) {
        for (long[] shard : this.shards) {
            Arrays.fill(shard, value);
        }
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        for (int i = 0; i < numberOfEntries; ++i) {
            long fromValue = this.get(fromIndex + (long)i);
            long toValue = this.get(toIndex + (long)i);
            this.set(fromIndex + (long)i, toValue);
            this.set(toIndex + (long)i, fromValue);
        }
    }

    private int arrayIndex(long index) {
        return index < Integer.MAX_VALUE ? (int)index : (int)(index % Integer.MAX_VALUE);
    }

    private int shardIndex(long index) {
        return index < Integer.MAX_VALUE ? 0 : (int)(index / Integer.MAX_VALUE);
    }
}

