/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Direction;
import org.neo4j.kernel.impl.cache.SizeOfObject;
import org.neo4j.kernel.impl.cache.SizeOfs;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.util.RelIdArrayWithLoops;
import org.neo4j.kernel.impl.util.RelIdIterator;
import org.neo4j.kernel.impl.util.RelationshipFilter;

public class RelIdArray
implements SizeOfObject {
    private static final DirectionWrapper[] DIRECTIONS_FOR_OUTGOING = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_INCOMING = new DirectionWrapper[]{DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    private static final DirectionWrapper[] DIRECTIONS_FOR_BOTH = new DirectionWrapper[]{DirectionWrapper.OUTGOING, DirectionWrapper.INCOMING, DirectionWrapper.BOTH};
    public static final RelIdArray EMPTY = new EmptyRelIdArray(-1);
    private final int type;
    private IdBlock outBlock;
    private IdBlock inBlock;

    public static RelIdArray empty(int type) {
        return new EmptyRelIdArray(type);
    }

    public RelIdArray(int type) {
        this.type = type;
    }

    @Override
    public int sizeOfObjectInBytesIncludingOverhead() {
        return SizeOfs.withObjectOverhead(8 + RelIdArray.sizeOfBlockWithReference(this.outBlock) + RelIdArray.sizeOfBlockWithReference(this.inBlock));
    }

    static int sizeOfBlockWithReference(IdBlock block) {
        return SizeOfs.withReference(block != null ? block.sizeOfObjectInBytesIncludingOverhead() : 0);
    }

    public int getType() {
        return this.type;
    }

    protected RelIdArray(RelIdArray from) {
        this(from.type);
        this.outBlock = from.outBlock;
        this.inBlock = from.inBlock;
    }

    protected RelIdArray(int type, IdBlock out, IdBlock in) {
        this(type);
        this.outBlock = out;
        this.inBlock = in;
    }

    public void add(long id, DirectionWrapper direction) {
        IdBlock block = direction.getBlock(this);
        if (block == null || !block.accepts(id)) {
            IdBlock newBlock = null;
            newBlock = block == null && LowIdBlock.idIsLow(id) ? new LowIdBlock() : (block != null ? block.upgradeToHighIdBlock() : new HighIdBlock());
            direction.setBlock(this, newBlock);
            block = newBlock;
        }
        block.add(id);
    }

    protected boolean accepts(RelIdArray source) {
        return source.getLastLoopBlock() == null;
    }

    public RelIdArray addAll(RelIdArray source) {
        return this.addAll(source, RelationshipFilter.ACCEPT_ALL);
    }

    public RelIdArray addAll(RelIdArray source, RelationshipFilter filter) {
        if (!this.accepts(source)) {
            return this.upgradeIfNeeded(source).addAll(source, filter);
        }
        this.appendFrom(source, DirectionWrapper.OUTGOING, filter);
        this.appendFrom(source, DirectionWrapper.INCOMING, filter);
        this.appendFrom(source, DirectionWrapper.BOTH, filter);
        return this;
    }

    protected IdBlock getLastLoopBlock() {
        return null;
    }

    public void shrink() {
        this.shrink(this.outBlock);
        this.shrink(this.inBlock);
        this.shrink(this.getLastLoopBlock());
    }

    protected void shrink(IdBlock block) {
        if (block != null) {
            block.shrink();
        }
    }

    protected void setLastLoopBlock(IdBlock block) {
        throw new UnsupportedOperationException("Should've upgraded to RelIdArrayWithLoops before this");
    }

    public RelIdArray upgradeIfNeeded(RelIdArray capabilitiesToMatch) {
        return capabilitiesToMatch.getLastLoopBlock() != null ? new RelIdArrayWithLoops(this) : this;
    }

    public RelIdArray downgradeIfPossible() {
        return this;
    }

    protected void appendFrom(RelIdArray source, DirectionWrapper direction, RelationshipFilter filter) {
        IdBlock fromBlock = direction.getBlock(source);
        if (fromBlock == null || !filter.accept(this.type, direction, direction.firstId(this))) {
            return;
        }
        IdBlock toBlock = direction.getBlock(this);
        if (toBlock == null) {
            direction.setBlock(this, fromBlock.copyAndShrink());
        } else if (toBlock.accepts(fromBlock)) {
            toBlock.addAll(fromBlock);
        } else {
            toBlock = toBlock.upgradeToHighIdBlock();
            toBlock.addAll(fromBlock);
            direction.setBlock(this, toBlock);
        }
    }

    public boolean isEmpty() {
        return this.outBlock == null && this.inBlock == null && this.getLastLoopBlock() == null;
    }

    public RelIdIterator iterator(DirectionWrapper direction) {
        return direction.iterator(this);
    }

    protected RelIdArray newSimilarInstance() {
        return new RelIdArray(this.type);
    }

    public static DirectionWrapper wrap(Direction direction) {
        switch (direction) {
            case OUTGOING: {
                return DirectionWrapper.OUTGOING;
            }
            case INCOMING: {
                return DirectionWrapper.INCOMING;
            }
            case BOTH: {
                return DirectionWrapper.BOTH;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)direction));
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, Collection<Long> remove) {
        return RelIdArray.from(src, add, remove, RelationshipFilter.ACCEPT_ALL);
    }

    public static RelIdArray from(RelIdArray src, RelIdArray add, Collection<Long> remove, RelationshipFilter filter) {
        if (remove == null) {
            if (src == null) {
                assert (add != null);
                RelIdArray newArray = add.downgradeIfPossible().newSimilarInstance();
                newArray.addAll(add, filter);
                return newArray;
            }
            if (add != null) {
                src = src.addAll(add, filter);
                return src.downgradeIfPossible();
            }
            return src;
        }
        if (src == null && add == null) {
            return null;
        }
        RelIdArray newArray = null;
        if (src != null) {
            newArray = src.newSimilarInstance();
            newArray.addAll(src);
            RelIdArray.evictExcluded(newArray, remove);
        } else {
            newArray = add.newSimilarInstance();
        }
        if (add != null) {
            newArray = newArray.upgradeIfNeeded(add);
            RelIdArray.evictExcluded(add, remove);
            newArray.addAll(add, filter);
        }
        return newArray;
    }

    private static void evictExcluded(RelIdArray ids, Collection<Long> excluded) {
        RelIdIteratorImpl iterator = (RelIdIteratorImpl)DirectionWrapper.BOTH.iterator(ids);
        while (iterator.hasNext()) {
            long value = iterator.next();
            if (!excluded.contains(value)) continue;
            boolean swapSuccessful = false;
            IteratorState state = iterator.currentState;
            IdBlock block = state.block;
            for (int j = block.length() - 1; j >= state.relativePosition; --j) {
                long backValue = block.get(j);
                block.setLength(block.length() - 1);
                state.length--;
                if (excluded.contains(backValue)) continue;
                block.set(backValue, state.relativePosition - 1);
                swapSuccessful = true;
                break;
            }
            if (swapSuccessful) continue;
            block.setLength(block.length() - 1);
        }
    }

    public int length(DirectionWrapper dir) {
        int result = 0;
        for (DirectionWrapper direction : dir.allDirections()) {
            IdBlock block = direction.getBlock(this);
            if (block == null) continue;
            result += block.length();
        }
        return result;
    }

    public String toString() {
        IdBlock loopBlock = DirectionWrapper.BOTH.getBlock(this);
        return "RelIdArray for type " + this.type + ":\n" + "  out: " + (this.outBlock != null ? this.outBlock.toString() : "") + "\n" + "  in:  " + (this.inBlock != null ? this.inBlock.toString() : "") + "\n" + "  loop:" + (loopBlock != null ? loopBlock.toString() : "") + "\n";
    }

    public static class RelIdIteratorImpl
    implements RelIdIterator {
        private final DirectionWrapper[] directions;
        private byte directionPosition = (byte)-1;
        private DirectionWrapper currentDirection;
        private IteratorState currentState;
        private final IteratorState[] states;
        private long nextElement;
        private boolean nextElementDetermined;
        private RelIdArray ids;

        RelIdIteratorImpl(RelIdArray ids, DirectionWrapper[] directions) {
            this.ids = ids;
            this.directions = directions;
            this.states = new IteratorState[directions.length];
            IdBlock block = null;
            while (block == null && this.directionPosition + 1 < directions.length) {
                this.directionPosition = (byte)(this.directionPosition + 1);
                this.currentDirection = directions[this.directionPosition];
                block = this.currentDirection.getBlock(ids);
            }
            if (block != null) {
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
            }
        }

        @Override
        public int getType() {
            return this.ids.getType();
        }

        @Override
        public RelIdIterator updateSource(RelIdArray newSource, DirectionWrapper direction) {
            this.ids = newSource;
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] == null) continue;
                this.states[i].update(this.directions[i].getBlock(this.ids));
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.nextElementDetermined) {
                return this.nextElement != -1L;
            }
            do {
                if (this.currentState == null || !this.currentState.hasNext()) continue;
                this.nextElement = this.currentState.next();
                this.nextElementDetermined = true;
                return true;
            } while (this.nextBlock());
            this.nextElementDetermined = false;
            this.nextElement = -1L;
            return false;
        }

        protected boolean nextBlock() {
            while (this.directionPosition + 1 < this.directions.length) {
                this.directionPosition = (byte)(this.directionPosition + 1);
                this.currentDirection = this.directions[this.directionPosition];
                IteratorState nextState = this.states[this.directionPosition];
                if (nextState != null) {
                    this.currentState = nextState;
                    return true;
                }
                IdBlock block = this.currentDirection.getBlock(this.ids);
                if (block == null) continue;
                this.states[this.directionPosition] = this.currentState = new IteratorState(block, 0);
                return true;
            }
            return false;
        }

        @Override
        public void doAnotherRound() {
            this.directionPosition = (byte)-1;
            this.nextBlock();
        }

        @Override
        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.nextElementDetermined = false;
            return this.nextElement;
        }
    }

    private static class IteratorState {
        private IdBlock block;
        private int relativePosition;
        private int length;

        public IteratorState(IdBlock block, int relativePosition) {
            this.block = block;
            this.relativePosition = relativePosition;
            this.length = block.length();
        }

        boolean hasNext() {
            return this.relativePosition < this.length;
        }

        long next() {
            return this.block.get(this.relativePosition++);
        }

        public void update(IdBlock block) {
            this.block = block;
            this.length = block.length();
        }
    }

    private static class HighIdBlock
    extends IdBlock {
        private int[] ids;
        private byte[] highBits;

        public HighIdBlock() {
            this.ids = new int[3];
            this.highBits = new byte[3];
        }

        private HighIdBlock(LowIdBlock lowIdBlock) {
            this.ids = Arrays.copyOf(lowIdBlock.ids, lowIdBlock.ids.length);
            this.highBits = new byte[this.ids.length];
        }

        @Override
        public int sizeOfObjectInBytesIncludingOverhead() {
            return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.withArrayOverhead(4 * this.ids.length)) + SizeOfs.withReference(SizeOfs.withArrayOverhead(this.ids.length)));
        }

        @Override
        protected boolean accepts(long id) {
            return true;
        }

        @Override
        protected boolean accepts(IdBlock block) {
            return true;
        }

        @Override
        protected void append(IdBlock source, int targetStartIndex, int itemsToCopy) {
            if (source instanceof LowIdBlock) {
                System.arraycopy(((LowIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
            } else {
                System.arraycopy(((HighIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
                System.arraycopy(((HighIdBlock)source).highBits, 1, this.highBits, targetStartIndex, itemsToCopy);
            }
        }

        @Override
        IdBlock upgradeToHighIdBlock() {
            return this;
        }

        @Override
        void shrink() {
            int itemsToCopy = this.length() + 1;
            this.ids = Arrays.copyOf(this.ids, itemsToCopy);
            this.highBits = Arrays.copyOf(this.highBits, itemsToCopy);
        }

        @Override
        protected IdBlock copyAndShrink() {
            HighIdBlock copy = new HighIdBlock();
            int itemsToCopy = this.length() + 1;
            copy.ids = Arrays.copyOf(this.ids, itemsToCopy);
            copy.highBits = Arrays.copyOf(this.highBits, itemsToCopy);
            return copy;
        }

        @Override
        protected void extendArrayTo(int numberOfItemsToCopy, int newLength) {
            int[] newIds = new int[newLength + 1];
            byte[] newHighBits = new byte[newLength + 1];
            System.arraycopy(this.ids, 0, newIds, 0, numberOfItemsToCopy + 1);
            System.arraycopy(this.highBits, 0, newHighBits, 0, numberOfItemsToCopy + 1);
            this.ids = newIds;
            this.highBits = newHighBits;
        }

        @Override
        protected int length() {
            return this.ids[0];
        }

        @Override
        protected int capacity() {
            return this.ids.length - 1;
        }

        @Override
        protected void setLength(int length) {
            this.ids[0] = length;
        }

        @Override
        protected long get(int index) {
            return (long)this.highBits[index + 1] << 32 | (long)this.ids[index + 1] & 0xFFFFFFFFL;
        }

        @Override
        protected void set(long id, int index) {
            this.ids[index + 1] = (int)id;
            this.highBits[index + 1] = (byte)((id & 0xFF00000000L) >>> 32);
        }
    }

    private static class LowIdBlock
    extends IdBlock {
        private int[] ids = new int[3];

        private LowIdBlock() {
        }

        @Override
        public int sizeOfObjectInBytesIncludingOverhead() {
            return SizeOfs.withObjectOverhead(SizeOfs.withReference(SizeOfs.withArrayOverhead(4 * this.ids.length)));
        }

        public static boolean idIsLow(long id) {
            return (id & 0xFF00000000L) == 0L;
        }

        @Override
        protected boolean accepts(long id) {
            return LowIdBlock.idIsLow(id);
        }

        @Override
        protected boolean accepts(IdBlock block) {
            return block instanceof LowIdBlock;
        }

        @Override
        protected void append(IdBlock source, int targetStartIndex, int itemsToCopy) {
            if (!(source instanceof LowIdBlock)) {
                throw new IllegalArgumentException(source.toString());
            }
            System.arraycopy(((LowIdBlock)source).ids, 1, this.ids, targetStartIndex, itemsToCopy);
        }

        @Override
        IdBlock upgradeToHighIdBlock() {
            return new HighIdBlock(this);
        }

        @Override
        void shrink() {
            if (this.capacity() > this.length()) {
                this.ids = Arrays.copyOf(this.ids, this.length() + 1);
            }
        }

        @Override
        protected IdBlock copyAndShrink() {
            LowIdBlock copy = new LowIdBlock();
            copy.ids = Arrays.copyOf(this.ids, this.length() + 1);
            return copy;
        }

        @Override
        protected void extendArrayTo(int numberOfItemsToCopy, int newLength) {
            int[] newIds = new int[newLength + 1];
            System.arraycopy(this.ids, 0, newIds, 0, numberOfItemsToCopy + 1);
            this.ids = newIds;
        }

        @Override
        protected int length() {
            return this.ids[0];
        }

        @Override
        protected int capacity() {
            return this.ids.length - 1;
        }

        @Override
        protected void setLength(int length) {
            this.ids[0] = length;
        }

        @Override
        protected long get(int index) {
            assert (index >= 0 && index < this.length());
            return (long)this.ids[index + 1] & 0xFFFFFFFFL;
        }

        @Override
        protected void set(long id, int index) {
            this.ids[index + 1] = (int)id;
        }
    }

    public static abstract class IdBlock
    implements SizeOfObject {
        abstract void shrink();

        void add(long id) {
            int length = this.ensureSpace(1);
            this.set(id, length);
            this.setLength(length + 1);
        }

        void addAll(IdBlock block) {
            int otherBlockLength = block.length();
            int length = this.ensureSpace(otherBlockLength + 1);
            this.append(block, length + 1, otherBlockLength);
            this.setLength(otherBlockLength + length);
        }

        int ensureSpace(int delta) {
            int capacity;
            int length = this.length();
            int newLength = length + delta;
            if (newLength >= (capacity = this.capacity())) {
                int calculatedLength = capacity * 2;
                if (newLength > calculatedLength) {
                    calculatedLength = newLength * 2;
                }
                this.extendArrayTo(length, calculatedLength);
            }
            return length;
        }

        protected abstract boolean accepts(long var1);

        protected abstract boolean accepts(IdBlock var1);

        protected abstract IdBlock copyAndShrink();

        abstract IdBlock upgradeToHighIdBlock();

        protected abstract void extendArrayTo(int var1, int var2);

        protected abstract void setLength(int var1);

        protected abstract int length();

        protected abstract int capacity();

        protected abstract void append(IdBlock var1, int var2, int var3);

        protected abstract long get(int var1);

        protected abstract void set(long var1, int var3);

        public String toString() {
            StringBuilder builder = new StringBuilder("[");
            int len = this.length();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    builder.append(",");
                    if (i % 10 == 0) {
                        builder.append("\n");
                    }
                }
                builder.append(this.get(i));
            }
            return builder.append("]").toString();
        }
    }

    public static enum DirectionWrapper {
        OUTGOING(Direction.OUTGOING){

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.outBlock;
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.outBlock = block;
            }

            @Override
            public long getNextRel(RelationshipGroupRecord group) {
                return group.getFirstOut();
            }

            @Override
            public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
                group.setFirstOut(firstNextRel);
            }

            @Override
            public DirectionWrapper[] allDirections() {
                return DIRECTIONS_FOR_OUTGOING;
            }
        }
        ,
        INCOMING(Direction.INCOMING){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIteratorImpl(ids, DIRECTIONS_FOR_INCOMING);
            }

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.inBlock;
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.inBlock = block;
            }

            @Override
            public long getNextRel(RelationshipGroupRecord group) {
                return group.getFirstIn();
            }

            @Override
            public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
                group.setFirstIn(firstNextRel);
            }

            @Override
            public DirectionWrapper[] allDirections() {
                return DIRECTIONS_FOR_INCOMING;
            }
        }
        ,
        BOTH(Direction.BOTH){

            @Override
            RelIdIterator iterator(RelIdArray ids) {
                return new RelIdIteratorImpl(ids, DIRECTIONS_FOR_BOTH);
            }

            @Override
            IdBlock getBlock(RelIdArray ids) {
                return ids.getLastLoopBlock();
            }

            @Override
            void setBlock(RelIdArray ids, IdBlock block) {
                ids.setLastLoopBlock(block);
            }

            @Override
            public long getNextRel(RelationshipGroupRecord group) {
                return group.getFirstLoop();
            }

            @Override
            public void setNextRel(RelationshipGroupRecord group, long firstNextRel) {
                group.setFirstLoop(firstNextRel);
            }

            @Override
            public DirectionWrapper[] allDirections() {
                return DIRECTIONS_FOR_BOTH;
            }
        };

        private final Direction direction;

        private DirectionWrapper(Direction direction) {
            this.direction = direction;
        }

        public long firstId(RelIdArray ids) {
            IdBlock block = this.getBlock(ids);
            return block != null && block.length() > 0 ? block.get(0) : (long)Record.NO_NEXT_RELATIONSHIP.intValue();
        }

        RelIdIterator iterator(RelIdArray ids) {
            return new RelIdIteratorImpl(ids, this.allDirections());
        }

        abstract IdBlock getBlock(RelIdArray var1);

        abstract void setBlock(RelIdArray var1, IdBlock var2);

        public Direction direction() {
            return this.direction;
        }

        public abstract long getNextRel(RelationshipGroupRecord var1);

        public abstract void setNextRel(RelationshipGroupRecord var1, long var2);

        public abstract DirectionWrapper[] allDirections();
    }

    public static class EmptyRelIdArray
    extends RelIdArray {
        private static final DirectionWrapper[] EMPTY_DIRECTION_ARRAY = new DirectionWrapper[0];
        private final RelIdIterator EMPTY_ITERATOR = new RelIdIteratorImpl(this, EMPTY_DIRECTION_ARRAY){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            protected boolean nextBlock() {
                return false;
            }

            @Override
            public void doAnotherRound() {
            }

            @Override
            public RelIdIterator updateSource(RelIdArray newSource, DirectionWrapper direction) {
                return direction.iterator(newSource);
            }
        };

        private EmptyRelIdArray(int type) {
            super(type);
        }

        @Override
        public RelIdIterator iterator(DirectionWrapper direction) {
            return this.EMPTY_ITERATOR;
        }
    }
}

