/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.AliasResolver;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.EmbeddedAliasTree;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParameter;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryParsingResult;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.OrderByClause;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jPredicateFactory;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class Neo4jQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<StringBuilder, Neo4jQueryParsingResult> {
    private final Neo4jPropertyHelper propertyHelper;
    private final SessionFactoryImplementor sessionFactory;
    private List<OrderByClause> orderByExpressions;
    private final List<String> embeddedPropertyProjection;
    private final AliasResolver embeddedAliasResolver;

    public Neo4jQueryRendererDelegate(SessionFactoryImplementor sessionFactory, AliasResolver embeddedAliasResolver, EntityNamesResolver entityNames, Neo4jPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super((PropertyHelper)propertyHelper, entityNames, Neo4jQueryRendererDelegate.singleEntityQueryBuilder(propertyHelper, embeddedAliasResolver), namedParameters);
        this.sessionFactory = sessionFactory;
        this.embeddedAliasResolver = embeddedAliasResolver;
        this.propertyHelper = propertyHelper;
        this.embeddedPropertyProjection = new ArrayList<String>();
    }

    private static SingleEntityQueryBuilder<StringBuilder> singleEntityQueryBuilder(Neo4jPropertyHelper propertyHelper, AliasResolver embeddedAliasResolver) {
        return SingleEntityQueryBuilder.getInstance((PredicateFactory)new Neo4jPredicateFactory(propertyHelper, embeddedAliasResolver), (PropertyHelper)propertyHelper);
    }

    private EntityKeyMetadata getKeyMetaData(Class<?> entityType) {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(entityType.getName());
        return persister.getEntityKeyMetadata();
    }

    public Neo4jQueryParsingResult getResult() {
        String targetAlias = this.embeddedAliasResolver.findAliasForType(this.targetTypeName);
        String label = this.getKeyMetaData(this.targetType).getTable();
        StringBuilder queryBuilder = new StringBuilder();
        this.match(queryBuilder, targetAlias, label);
        this.where(queryBuilder);
        this.optionalMatch(queryBuilder, targetAlias);
        this.returns(queryBuilder, targetAlias);
        this.orderBy(queryBuilder);
        return new Neo4jQueryParsingResult(this.targetType, this.projections, queryBuilder.toString());
    }

    private void match(StringBuilder queryBuilder, String targetAlias, String label) {
        queryBuilder.append("MATCH ");
        CypherDSL.node(queryBuilder, targetAlias, label);
        EmbeddedAliasTree node = this.embeddedAliasResolver.getAliasTree(targetAlias);
        if (node != null) {
            boolean first = true;
            for (EmbeddedAliasTree child : node.getChildren()) {
                if (this.embeddedAliasResolver.isOptionalMatch(child.getAlias())) continue;
                StringBuilder embeddedMatch = new StringBuilder();
                if (first) {
                    first = false;
                } else {
                    embeddedMatch.append(", ");
                    CypherDSL.node(embeddedMatch, targetAlias, label);
                }
                CypherDSL.relationship(embeddedMatch, child.getName());
                CypherDSL.node(embeddedMatch, child.getAlias(), NodeLabel.EMBEDDED.name());
                this.appendEmbedded(queryBuilder, embeddedMatch.toString(), child, true);
            }
        }
    }

    private void optionalMatch(StringBuilder queryBuilder, String targetAlias) {
        EmbeddedAliasTree node = this.embeddedAliasResolver.getAliasTree(targetAlias);
        if (node != null) {
            this.appendOptionalMatch(queryBuilder, targetAlias, node.getChildren());
        }
    }

    private void appendOptionalMatch(StringBuilder queryBuilder, String targetAlias, List<EmbeddedAliasTree> children) {
        for (EmbeddedAliasTree child : children) {
            if (this.embeddedAliasResolver.isOptionalMatch(child.getAlias())) {
                queryBuilder.append(" OPTIONAL MATCH ");
                CypherDSL.node(queryBuilder, targetAlias, new String[0]);
                CypherDSL.relationship(queryBuilder, child.getName());
                CypherDSL.node(queryBuilder, child.getAlias(), NodeLabel.EMBEDDED.name());
            }
            this.appendOptionalMatch(queryBuilder, child.getAlias(), child.getChildren());
        }
    }

    private void appendEmbedded(StringBuilder queryBuilder, String currentMatch, EmbeddedAliasTree node, boolean matchCondition) {
        if (node.getChildren().isEmpty()) {
            queryBuilder.append(currentMatch);
        } else {
            for (EmbeddedAliasTree child : node.getChildren()) {
                boolean optional = this.embeddedAliasResolver.isOptionalMatch(child.getAlias());
                if (matchCondition && !optional || !matchCondition) {
                    StringBuilder builder = new StringBuilder(currentMatch);
                    CypherDSL.relationship(builder, child.getName());
                    CypherDSL.node(builder, child.getAlias(), NodeLabel.EMBEDDED.name());
                    this.appendEmbedded(queryBuilder, builder.toString(), child, matchCondition);
                    continue;
                }
                queryBuilder.append(currentMatch);
            }
        }
    }

    private void where(StringBuilder queryBuilder) {
        StringBuilder whereCondition = (StringBuilder)this.builder.build();
        if (whereCondition != null) {
            queryBuilder.append(" WHERE ");
            queryBuilder.append((CharSequence)whereCondition);
        }
    }

    private void orderBy(StringBuilder queryBuilder) {
        if (this.orderByExpressions != null && !this.orderByExpressions.isEmpty()) {
            queryBuilder.append(" ORDER BY ");
            int counter = 1;
            for (OrderByClause orderBy : this.orderByExpressions) {
                orderBy.asString(queryBuilder);
                if (counter++ >= this.orderByExpressions.size()) continue;
                queryBuilder.append(", ");
            }
        }
    }

    private void returns(StringBuilder builder, String targetAlias) {
        builder.append(" RETURN ");
        if (this.projections.isEmpty()) {
            CypherDSL.identifier(builder, targetAlias);
        } else {
            int counter = 1;
            for (String projection : this.projections) {
                if (this.embeddedPropertyProjection.contains(projection)) {
                    builder.append(projection);
                } else {
                    CypherDSL.identifier(builder, targetAlias, projection);
                    CypherDSL.as(builder, projection);
                }
                if (counter++ >= this.projections.size()) continue;
                builder.append(", ");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyPath(PropertyPath path) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            List pathWithoutAlias = this.resolveAlias(path);
            if (this.propertyHelper.isSimpleProperty(pathWithoutAlias)) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, (List<String>)pathWithoutAlias));
                return;
            } else {
                if (!this.propertyHelper.isNestedProperty(pathWithoutAlias)) return;
                if (!this.propertyHelper.isEmbeddedProperty(this.targetTypeName, pathWithoutAlias)) throw new UnsupportedOperationException("Selecting associated properties not yet implemented.");
                String entityAlias = this.entityAlias(path);
                List associationPath = this.propertyHelper.findAssociationPath(this.targetTypeName, pathWithoutAlias);
                if (associationPath != null) {
                    ArrayList<String> nextPath = new ArrayList<String>(associationPath.size() + 1);
                    int next = associationPath.size();
                    nextPath.addAll(associationPath);
                    if (next < pathWithoutAlias.size() - 1) {
                        nextPath.add((String)pathWithoutAlias.get(next));
                    }
                    boolean leftJoin = false;
                    this.embeddedAliasResolver.createAliasForEmbedded(entityAlias, nextPath, leftJoin);
                }
                boolean optional = true;
                String embeddedAlias = this.embeddedAliasResolver.createAliasForEmbedded(entityAlias, pathWithoutAlias, optional);
                String columnName = this.propertyHelper.getEmbeddeColumnName(this.targetTypeName, pathWithoutAlias);
                String projection = CypherDSL.identifier(embeddedAlias, columnName);
                this.projections.add(projection);
                this.embeddedPropertyProjection.add(projection);
            }
            return;
        } else {
            this.propertyPath = path;
        }
    }

    private String entityAlias(PropertyPath path) {
        if (path.getFirstNode().isAlias()) {
            String alias = path.getFirstNode().getName();
            if (this.aliasToEntityType.containsKey(alias)) {
                return alias;
            }
            if (this.aliasToPropertyPath.containsKey(alias)) {
                PropertyPath resolvedAlias = (PropertyPath)this.aliasToPropertyPath.get(alias);
                if (resolvedAlias.getFirstNode().isAlias()) {
                    return resolvedAlias.getFirstNode().getName();
                }
                throw new HibernateException("It does not start with an alias");
            }
        }
        throw new HibernateException("It does not start with an alias");
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new ArrayList<OrderByClause>();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, (List<String>)propertyPath.getNodeNamesWithoutAlias());
        String alias = this.embeddedAliasResolver.findAliasForType(this.targetTypeName);
        OrderByClause order = new OrderByClause(alias, columnName, isAscending);
        this.orderByExpressions.add(order);
    }

    public void predicateLess(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS);
    }

    public void predicateLessOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.LESS_OR_EQUAL);
    }

    public void predicateEquals(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
    }

    public void predicateNotEquals(String comparativePredicate) {
        this.builder.pushNotPredicate();
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.EQUALS);
        this.builder.popBooleanPredicate();
    }

    public void predicateGreaterOrEqual(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER_OR_EQUAL);
    }

    public void predicateGreater(String comparativePredicate) {
        this.addComparisonPredicate(comparativePredicate, ComparisonPredicate.Type.GREATER);
    }

    private void addComparisonPredicate(String comparativePredicate, ComparisonPredicate.Type comparisonType) {
        Object comparisonValue = this.fromNamedQuery(comparativePredicate);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addComparisonPredicate(property, comparisonType, comparisonValue);
    }

    public void predicateIn(List<String> list) {
        List<Object> values = this.fromNamedQuery(list);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addInPredicate(property, values);
    }

    public void predicateBetween(String lower, String upper) {
        Object lowerComparisonValue = this.fromNamedQuery(lower);
        Object upperComparisonValue = this.fromNamedQuery(upper);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addRangePredicate(property, lowerComparisonValue, upperComparisonValue);
    }

    public void predicateLike(String patternValue, Character escapeCharacter) {
        Object pattern = this.fromNamedQuery(patternValue);
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addLikePredicate(property, (String)pattern, escapeCharacter);
    }

    public void predicateIsNull() {
        List property = this.resolveAlias(this.propertyPath);
        this.builder.addIsNullPredicate(property);
    }

    private Object fromNamedQuery(String comparativePredicate) {
        if (comparativePredicate.startsWith(":")) {
            return new Neo4jQueryParameter(comparativePredicate.substring(1));
        }
        ArrayList path = new ArrayList();
        path.addAll(this.propertyPath.getNodeNamesWithoutAlias());
        PropertyPath fullPath = this.propertyPath;
        while (fullPath.getFirstNode().isAlias() && this.aliasToPropertyPath.containsKey(fullPath.getFirstNode().getName())) {
            fullPath = (PropertyPath)this.aliasToPropertyPath.get(fullPath.getFirstNode().getName());
            path.addAll(0, fullPath.getNodeNamesWithoutAlias());
        }
        return this.propertyHelper.convertToPropertyType(this.targetTypeName, path, comparativePredicate);
    }

    private List<Object> fromNamedQuery(List<String> list) {
        ArrayList<Object> elements = new ArrayList<Object>(list.size());
        for (String string : list) {
            elements.add(this.fromNamedQuery(string));
        }
        return elements;
    }
}

