/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.DBObject;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.ogm.datastore.mongodb.dialect.impl.MongoHelpers;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class MongoDBTupleSnapshot
implements TupleSnapshot {
    public static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private final DBObject dbObject;
    private final EntityKeyMetadata keyMetadata;
    private SnapshotType snapshotType;

    public MongoDBTupleSnapshot(DBObject dbObject, EntityKeyMetadata meta, SnapshotType snapshotType) {
        this.dbObject = dbObject;
        this.keyMetadata = meta;
        this.snapshotType = snapshotType;
    }

    public DBObject getDbObject() {
        return this.dbObject;
    }

    public Set<String> getColumnNames() {
        return this.dbObject.keySet();
    }

    public SnapshotType getSnapshotType() {
        return this.snapshotType;
    }

    public void setSnapshotType(SnapshotType snapshotType) {
        this.snapshotType = snapshotType;
    }

    public boolean isEmpty() {
        return this.dbObject.keySet().isEmpty();
    }

    public boolean isKeyColumn(String column) {
        return this.keyMetadata != null && this.keyMetadata.isKeyColumn(column);
    }

    public Object get(String column) {
        return this.isKeyColumn(column) ? this.getKeyColumnValue(column) : this.getValue(this.dbObject, column);
    }

    private Object getKeyColumnValue(String column) {
        if (column.contains(".")) {
            DBObject idObject = (DBObject)this.dbObject.get("_id");
            String nestedColumn = column.substring(column.indexOf(".") + 1);
            return this.getValue(idObject, nestedColumn);
        }
        return this.dbObject.get("_id");
    }

    private Object getValue(DBObject dbObject, String column) {
        Object valueOrNull = MongoHelpers.getValueOrNull(dbObject, column);
        return valueOrNull;
    }

    public static enum SnapshotType {
        INSERT,
        UPDATE;

    }
}

