/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import java.util.regex.Pattern;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.ogm.util.impl.StringHelper;

public class OgmNamingStrategy
extends EJB3NamingStrategy {
    public static final NamingStrategy INSTANCE = new OgmNamingStrategy();
    private static final Pattern ELEMENT_COLLECTION_NAME_PATTERN = Pattern.compile("collection&&element\\.");

    private String replacePropertySeparator(String name) {
        return name;
    }

    public String propertyToColumnName(String propertyName) {
        String[] parts = ELEMENT_COLLECTION_NAME_PATTERN.split(propertyName);
        if (parts.length == 2) {
            propertyName = parts[1];
        }
        return this.replacePropertySeparator(propertyName);
    }

    public String collectionTableName(String ownerEntity, String ownerEntityTable, String associatedEntity, String associatedEntityTable, String propertyName) {
        return this.tableName(ownerEntityTable + "_" + (associatedEntityTable != null ? associatedEntityTable : this.replacePropertySeparator(propertyName)));
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String header;
        String string = header = propertyName != null ? this.replacePropertySeparator(propertyName) : propertyTableName;
        if (header == null) {
            throw new AssertionFailure("NamingStrategy not properly filled");
        }
        return this.columnName(header + "_" + referencedColumnName);
    }

    public String logicalColumnName(String columnName, String propertyName) {
        return !StringHelper.isEmpty(columnName) ? columnName : propertyName;
    }

    public String logicalCollectionTableName(String tableName, String ownerEntityTable, String associatedEntityTable, String propertyName) {
        if (tableName != null) {
            return tableName;
        }
        return new StringBuffer(ownerEntityTable).append("_").append(associatedEntityTable != null ? associatedEntityTable : propertyName).toString();
    }

    public String logicalCollectionColumnName(String columnName, String propertyName, String referencedColumn) {
        return !StringHelper.isEmpty(columnName) ? columnName : propertyName + "_" + referencedColumn;
    }
}

