/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.util.impl.CoreLogCategories;
import org.hibernate.ogm.util.impl.Log;
import org.jboss.logging.Logger;

public class GridDialectLogger
extends ForwardingGridDialect<Serializable> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)CoreLogCategories.DATASTORE_ACCESS.toString());

    public GridDialectLogger(GridDialect gridDialect) {
        super(gridDialect);
    }

    public static boolean activationNeeded() {
        return log.isTraceEnabled();
    }

    @Override
    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Reading tuple with key %1$s and context %2$s", key, tupleContext);
        return super.getTuple(key, tupleContext);
    }

    @Override
    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Creating tuple with key %1$s", key);
        return super.createTuple(key, tupleContext);
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        if (tuple.getSnapshot().isEmpty()) {
            log.tracef("Inserting tuple with key %1$s into datastore", key);
        } else {
            log.tracef("Updating tuple with key %1$s in datastore", key);
        }
        super.insertOrUpdateTuple(key, tuple, tupleContext);
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        log.tracef("Removing tuple with key %1$s from datastore", key);
        super.removeTuple(key, tupleContext);
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Reading association with key %1$s from datastore and context %2$s", key, associationContext);
        return super.getAssociation(key, associationContext);
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Creating association with key %1$s", key);
        return super.createAssociation(key, associationContext);
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (association.getSnapshot().size() == 0) {
            log.tracef("Creating association with key %1$s in datastore", key);
        } else {
            log.tracef("Updating association with key %1$s in datastore", key);
        }
        super.insertOrUpdateAssociation(key, association, associationContext);
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        log.tracef("Removing association with key %1$s from datastore", key);
        super.removeAssociation(key, associationContext);
    }

    @Override
    public Number nextValue(NextValueRequest request) {
        log.tracef("Extracting next value from key %1$s", request.getKey());
        return super.nextValue(request);
    }

    @Override
    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        log.tracef("Determining whether association %1$s is stored in an entity structure", associationKeyMetadata);
        return super.isStoredInEntityStructure(associationKeyMetadata, associationTypeContext);
    }

    @Override
    public void executeBatch(OperationsQueue queue) {
        log.tracef("Executing batch with %1$s items", queue.size());
        super.executeBatch(queue);
    }

    @Override
    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<Serializable> query, QueryParameters queryParameters) {
        log.tracef("Executing backend query: %1$s", query.getQuery());
        return super.executeBackendQuery(query, queryParameters);
    }
}

