/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionDelegatorBaseImpl;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.OgmSession;
import org.hibernate.ogm.OgmSessionFactory;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.BackendCustomLoader;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryImpl;
import org.hibernate.ogm.hibernatecore.impl.OgmSharedSessionBuilderDelegator;
import org.hibernate.ogm.loader.nativeloader.impl.BackendCustomQuery;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.query.NoSQLQuery;
import org.hibernate.ogm.query.impl.NoSQLQueryImpl;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.type.Type;

public class OgmSessionImpl
extends SessionDelegatorBaseImpl
implements OgmSession,
EventSource {
    private static final Log log = LoggerFactory.make();
    private final EventSource delegate;
    private final OgmSessionFactoryImpl factory;

    public OgmSessionImpl(OgmSessionFactory factory, EventSource delegate) {
        super((SessionImplementor)delegate, (Session)delegate);
        this.delegate = delegate;
        this.factory = (OgmSessionFactoryImpl)factory;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public OgmSessionFactory getSessionFactory() {
        return this.factory;
    }

    public Criteria createCriteria(Class persistentClass) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Query createQuery(NamedQueryDefinition namedQueryDefinition) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String queryString = namedQueryDefinition.getQueryString();
        Query query = this.createQuery(queryString);
        query.setComment("named HQL/JP-QL query " + namedQueryDefinition.getName());
        query.setFlushMode(namedQueryDefinition.getFlushMode());
        return query;
    }

    @Override
    public NoSQLQuery createSQLQuery(String queryString) throws HibernateException {
        return this.createNativeQuery(queryString);
    }

    public SQLQuery createSQLQuery(NamedSQLQueryDefinition namedQueryDefinition) {
        return this.createNativeQuery(namedQueryDefinition.getQuery());
    }

    @Override
    public NoSQLQuery createNativeQuery(String nativeQuery) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new NoSQLQueryImpl(nativeQuery, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nativeQuery));
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        throw new NotSupportedException("OGM-24", "filters are not supported yet");
    }

    public Filter enableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public void doWork(Work work) throws HibernateException {
        throw new IllegalStateException("Hibernate OGM does not support SQL Connections hence no Work");
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.delegate.doReturningWork(work);
    }

    public ProcedureCall getNamedProcedureCall(String name) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, Class ... resultClasses) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ProcedureCall createStoredProcedureCall(String procedureName, String ... resultSetMappings) {
        throw new NotSupportedException("OGM-359", "Stored procedures are not supported yet");
    }

    public ActionQueue getActionQueue() {
        return this.delegate.getActionQueue();
    }

    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        return this.delegate.instantiate(persister, id);
    }

    public void forceFlush(EntityEntry e) throws HibernateException {
        this.delegate.forceFlush(e);
    }

    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.delegate.merge(entityName, object, copiedAlready);
    }

    public void persist(String entityName, Object object, Map createdAlready) throws HibernateException {
        this.delegate.persist(entityName, object, createdAlready);
    }

    public void persistOnFlush(String entityName, Object object, Map copiedAlready) {
        this.delegate.persistOnFlush(entityName, object, copiedAlready);
    }

    public void refresh(String entityName, Object object, Map refreshedAlready) throws HibernateException {
        this.delegate.refresh(entityName, object, refreshedAlready);
    }

    public void delete(String entityName, Object child, boolean isCascadeDeleteEnabled, Set transientEntities) {
        this.delegate.delete(entityName, child, isCascadeDeleteEnabled, transientEntities);
    }

    public JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.delegate.getJdbcConnectionAccess();
    }

    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return this.delegate.generateEntityKey(id, persister);
    }

    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        return this.delegate.generateCacheKey(id, type, entityOrRoleName);
    }

    public List<?> listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.tracev("NoSQL query: {0}", customQuery.getSQL());
        }
        BackendCustomLoader loader = new BackendCustomLoader((BackendCustomQuery)customQuery, this.getFactory());
        this.autoFlushIfRequired(loader.getQuerySpaces());
        return loader.list((SessionImplementor)this.getDelegate(), queryParameters);
    }

    private boolean autoFlushIfRequired(Set<String> querySpaces) throws HibernateException {
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, this.getDelegate());
        for (AutoFlushEventListener listener : this.listeners(EventType.AUTO_FLUSH)) {
            listener.onAutoFlush(event);
        }
        return event.isFlushRequired();
    }

    private <T> Iterable<T> listeners(EventType<T> type) {
        return this.eventListenerGroup(type).listeners();
    }

    private <T> EventListenerGroup<T> eventListenerGroup(EventType<T> type) {
        return ((EventListenerRegistry)this.factory.getServiceRegistry().getService(EventListenerRegistry.class)).getEventListenerGroup(type);
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scrollCustomQuery(customQuery, queryParameters);
    }

    public List<?> list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scroll(spec, queryParameters);
    }

    public Query getNamedQuery(String name) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        NamedQueryDefinition namedQuery = this.factory.getNamedQuery(name);
        if (namedQuery == null) {
            return this.getNamedSQLQuery(name);
        }
        return this.createQuery(namedQuery);
    }

    public Query getNamedSQLQuery(String queryName) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        NamedSQLQueryDefinition nsqlqd = this.findNamedNativeQuery(queryName);
        NoSQLQueryImpl query = new NoSQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQuery()));
        query.setComment("named native query " + queryName);
        return query;
    }

    private NamedSQLQueryDefinition findNamedNativeQuery(String queryName) {
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named native query not found: " + queryName);
        }
        return nsqlqd;
    }

    public SharedSessionBuilder sessionWithOptions() {
        return new OgmSharedSessionBuilderDelegator(this.delegate.sessionWithOptions(), this.factory);
    }

    protected void errorIfClosed() {
        if (this.delegate.isClosed()) {
            throw new SessionException("Session is closed!");
        }
    }

    private void checkTransactionSynchStatus() {
        this.pulseTransactionCoordinator();
        this.delayedAfterCompletion();
    }

    private void pulseTransactionCoordinator() {
        if (!this.isClosed()) {
            this.delegate.getTransactionCoordinator().pulse();
        }
    }

    private void delayedAfterCompletion() {
        this.delegate.getTransactionCoordinator().getSynchronizationCallbackCoordinator().processAnyDelayedAfterCompletion();
    }

    public <G extends GlobalContext<?, ?>, D extends DatastoreConfiguration<G>> G configureDatastore(Class<D> datastoreType) {
        throw new UnsupportedOperationException("OGM-343 Session specific options are not currently supported");
    }

    public void removeOrphanBeforeUpdates(String entityName, Object child) {
        this.delegate.removeOrphanBeforeUpdates(entityName, child);
    }

    public EventSource getDelegate() {
        return this.delegate;
    }

    public NaturalIdLoadAccess byNaturalId(Class entityClass) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class entityClass) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        throw new UnsupportedOperationException("OGM-589 - Natural id look-ups are not yet supported");
    }
}

