/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.impl;

import java.util.Map;
import org.hibernate.ogm.options.container.impl.OptionsContainerBuilder;
import org.hibernate.ogm.options.navigation.impl.PropertyKey;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class AppendableConfigurationContext {
    private final OptionsContainerBuilder globalOptions = new OptionsContainerBuilder();
    private final Map<Class<?>, OptionsContainerBuilder> optionsPerEntity = CollectionHelper.newConcurrentHashMap();
    private final Map<PropertyKey, OptionsContainerBuilder> optionsPerProperty = CollectionHelper.newConcurrentHashMap();

    public <V> void addGlobalOption(Option<?, V> option, V value) {
        this.globalOptions.add(option, value);
    }

    public <V> void addEntityOption(Class<?> entityType, Option<?, V> option, V value) {
        OptionsContainerBuilder entityOptions = this.optionsPerEntity.get(entityType);
        if (entityOptions == null) {
            entityOptions = new OptionsContainerBuilder();
            this.optionsPerEntity.put(entityType, entityOptions);
        }
        entityOptions.add(option, value);
    }

    public <V> void addPropertyOption(Class<?> entityType, String propertyName, Option<?, V> option, V value) {
        PropertyKey key = new PropertyKey(entityType, propertyName);
        OptionsContainerBuilder propertyOptions = this.optionsPerProperty.get(key);
        if (propertyOptions == null) {
            propertyOptions = new OptionsContainerBuilder();
            this.optionsPerProperty.put(key, propertyOptions);
        }
        propertyOptions.add(option, value);
    }

    public OptionsContainerBuilder getGlobalOptions() {
        return this.globalOptions;
    }

    public Map<Class<?>, OptionsContainerBuilder> getEntityOptions() {
        return this.optionsPerEntity;
    }

    public Map<PropertyKey, OptionsContainerBuilder> getPropertyOptions() {
        return this.optionsPerProperty;
    }
}

