/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import org.hibernate.ConnectionReleaseMode;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.transaction.impl.ErrorHandlerEnabledTransactionDecorator;

public class ErrorHandlerEnabledTransactionDecoratorFactory
implements TransactionFactory<ErrorHandlerEnabledTransactionDecorator> {
    private final ErrorHandler errorHandler;
    private final TransactionFactory<?> delegate;
    private final JtaPlatform jtaPlatform;

    public ErrorHandlerEnabledTransactionDecoratorFactory(ErrorHandler errorHandler, TransactionFactory<?> delegate, JtaPlatform jtaPlatform) {
        this.errorHandler = errorHandler;
        this.delegate = delegate;
        this.jtaPlatform = jtaPlatform;
    }

    public ErrorHandlerEnabledTransactionDecorator createTransaction(TransactionCoordinator coordinator) {
        TransactionImplementor transaction = this.delegate.createTransaction(coordinator);
        return new ErrorHandlerEnabledTransactionDecorator(transaction, this.errorHandler, this.jtaPlatform);
    }

    public boolean canBeDriver() {
        return this.delegate.canBeDriver();
    }

    public boolean compatibleWithJtaSynchronization() {
        return this.delegate.compatibleWithJtaSynchronization();
    }

    public boolean isJoinableJtaTransaction(TransactionCoordinator transactionCoordinator, ErrorHandlerEnabledTransactionDecorator transaction) {
        return this.delegate.isJoinableJtaTransaction(transactionCoordinator, transaction.getDelegate());
    }

    public ConnectionReleaseMode getDefaultReleaseMode() {
        return this.delegate.getDefaultReleaseMode();
    }
}

