/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;
import org.hibernate.engine.transaction.internal.jta.JtaIsolationDelegate;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.AbstractTransactionImpl;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.JoinStatus;
import org.hibernate.engine.transaction.spi.LocalStatus;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class JTATransaction
extends AbstractTransactionImpl
implements Transaction {
    private static final Log log = LoggerFactory.make();
    private final TransactionManager transactionManager;
    private boolean isDriver;
    private boolean isInitiator;

    public JTATransaction(TransactionCoordinator coordinator) {
        super(coordinator);
        JtaPlatform jtaPlatform = coordinator.getTransactionContext().getTransactionEnvironment().getJtaPlatform();
        this.transactionManager = jtaPlatform.retrieveTransactionManager();
    }

    protected void doBegin() {
        log.trace("begin");
        try {
            boolean newTransaction;
            boolean bl = newTransaction = this.transactionManager.getStatus() == 6;
            if (newTransaction) {
                this.transactionManager.begin();
                this.isInitiator = true;
                log.trace("Began a new JTA transaction");
            }
        }
        catch (Exception e) {
            throw log.jtaTransactionBeginFailed(e);
        }
    }

    protected void afterTransactionBegin() {
        TransactionCoordinator coordinator = this.transactionCoordinator();
        coordinator.pulse();
        if (!coordinator.isSynchronizationRegistered()) {
            this.isDriver = coordinator.takeOwnership();
        }
        this.applyTimeout();
        coordinator.sendAfterTransactionBeginNotifications((TransactionImplementor)this);
        coordinator.getTransactionContext().afterTransactionBegin((TransactionImplementor)this);
    }

    protected void beforeTransactionCommit() {
        boolean flush;
        TransactionCoordinator coordinator = this.transactionCoordinator();
        coordinator.sendBeforeTransactionCompletionNotifications((TransactionImplementor)this);
        TransactionContext transactionContext = coordinator.getTransactionContext();
        boolean bl = flush = !transactionContext.isFlushModeNever() && (this.isDriver || !transactionContext.isFlushBeforeCompletionEnabled());
        if (flush) {
            transactionContext.managedFlush();
        }
        if (this.isDriver && this.isInitiator) {
            transactionContext.beforeTransactionCompletion((TransactionImplementor)this);
        }
        this.closeIfRequired();
    }

    private void closeIfRequired() throws HibernateException {
        boolean close;
        TransactionContext transactionContext = this.transactionCoordinator().getTransactionContext();
        boolean bl = close = this.isDriver && transactionContext.shouldAutoClose() && !transactionContext.isClosed();
        if (close) {
            transactionContext.managedClose();
        }
    }

    protected void doCommit() {
        try {
            if (this.isInitiator) {
                this.transactionManager.commit();
                log.debug("Committed JTA UserTransaction");
            }
        }
        catch (Exception e) {
            throw log.jtaCommitFailed(e);
        }
        finally {
            this.isInitiator = false;
        }
    }

    protected void afterTransactionCompletion(int status) {
        if (this.isDriver) {
            this.transactionCoordinator().afterTransaction((TransactionImplementor)this, status);
        }
    }

    protected void afterAfterCompletion() {
    }

    protected void beforeTransactionRollBack() {
    }

    protected void doRollback() {
        try {
            if (this.isInitiator) {
                if (this.getLocalStatus() != LocalStatus.FAILED_COMMIT) {
                    this.transactionManager.rollback();
                    log.debug("Rolled back JTA UserTransaction");
                }
            } else {
                this.markRollbackOnly();
            }
        }
        catch (Exception e) {
            throw log.jtaRollbackFailed(e);
        }
    }

    public void markRollbackOnly() {
        log.trace("Marking transaction for rollback only");
        try {
            this.transactionManager.setRollbackOnly();
            log.debug("set JTA UserTransaction to rollback only");
        }
        catch (SystemException e) {
            throw log.unableToMarkTransactionForRollback((Exception)((Object)e));
        }
    }

    public IsolationDelegate createIsolationDelegate() {
        return new JtaIsolationDelegate(this.transactionCoordinator());
    }

    public boolean isInitiator() {
        return this.isInitiator;
    }

    public boolean isActive() throws HibernateException {
        int status;
        if (this.getLocalStatus() != LocalStatus.ACTIVE) {
            return false;
        }
        try {
            status = this.transactionManager.getStatus();
        }
        catch (SystemException se) {
            throw log.jtaCouldNotDetermineStatus(se);
        }
        return JtaStatusHelper.isActive((int)status);
    }

    public void setTimeout(int seconds) {
        super.setTimeout(seconds);
        this.applyTimeout();
    }

    private void applyTimeout() {
        try {
            this.transactionManager.setTransactionTimeout(this.getTimeout());
        }
        catch (SystemException se) {
            throw log.unableToSetTimeout(se, this.getTimeout());
        }
    }

    public void join() {
    }

    public void resetJoinStatus() {
    }

    public JoinStatus getJoinStatus() {
        return JtaStatusHelper.isActive((TransactionManager)this.transactionManager) ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
    }
}

