/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.internal.TransactionFactoryInitiator;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.transaction.impl.ErrorHandlerEnabledTransactionDecoratorFactory;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactory;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmTransactionFactoryInitiator
implements StandardServiceInitiator<TransactionFactory> {
    public static final OgmTransactionFactoryInitiator INSTANCE = new OgmTransactionFactoryInitiator();
    private static final Log log = LoggerFactory.make();

    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    public TransactionFactory<?> initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        TransactionFactory<?> transactionFactory = null;
        if (this.hasExplicitNonJPAResourceLocalTransactionFactory(configurationValues)) {
            transactionFactory = TransactionFactoryInitiator.INSTANCE.initiateService(configurationValues, registry);
        } else {
            boolean emulateTransactions;
            DatastoreProvider datastoreProvider = (DatastoreProvider)registry.getService(DatastoreProvider.class);
            if (datastoreProvider.allowsTransactionEmulation()) {
                emulateTransactions = true;
            } else {
                log.usingDefaultTransactionFactory();
                emulateTransactions = false;
            }
            transactionFactory = new OgmTransactionFactory(emulateTransactions);
        }
        ErrorHandler errorHandler = this.getErrorHandler(configurationValues, registry);
        return errorHandler == null ? transactionFactory : this.getErrorHandlerEnabledFactory(registry, transactionFactory, errorHandler);
    }

    private ErrorHandler getErrorHandler(Map<?, ?> configurationValues, ServiceRegistryImplementor registry) {
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, (ClassLoaderService)registry.getService(ClassLoaderService.class));
        return (ErrorHandler)propertyReader.property("hibernate.ogm.error_handler", ErrorHandler.class).instantiate().getValue();
    }

    private TransactionFactory<?> getErrorHandlerEnabledFactory(ServiceRegistryImplementor registry, TransactionFactory<?> transactionFactory, ErrorHandler errorHandler) {
        JtaPlatform jtaPlatform = null;
        if (transactionFactory.compatibleWithJtaSynchronization()) {
            jtaPlatform = (JtaPlatform)registry.getService(JtaPlatform.class);
        }
        return new ErrorHandlerEnabledTransactionDecoratorFactory(errorHandler, transactionFactory, jtaPlatform);
    }

    private boolean hasExplicitNonJPAResourceLocalTransactionFactory(Map configurationValues) {
        Object strategy = configurationValues.get("hibernate.transaction.factory_class");
        return strategy != null && !this.isResourceLocalTransactionType(strategy);
    }

    private boolean isResourceLocalTransactionType(Object strategy) {
        return JdbcTransactionFactory.class.getName().equals(strategy) || JdbcTransactionFactory.class.equals(strategy);
    }
}

