/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.ogm.type.descriptor.impl.StringMappedGridTypeDescriptor;
import org.hibernate.ogm.type.impl.AbstractGenericBasicType;
import org.hibernate.type.descriptor.java.UUIDTypeDescriptor;

public class UUIDType
extends AbstractGenericBasicType<UUID> {
    public static final UUIDType INSTANCE = new UUIDType();

    public UUIDType() {
        super(StringMappedGridTypeDescriptor.INSTANCE, UUIDTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "uuid";
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public int getColumnSpan(Mapping mapping) {
        return 1;
    }

    @Override
    public String toString(UUID value) throws HibernateException {
        return value.toString();
    }

    @Override
    public UUID fromStringValue(String string) throws HibernateException {
        try {
            return UUID.fromString(string);
        }
        catch (NumberFormatException e) {
            throw new HibernateException("Unable to rebuild BigInteger from String", (Throwable)e);
        }
    }
}

