/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.logging.impl;

import java.text.ParseException;
import javax.persistence.OptimisticLockException;
import org.hibernate.HibernateException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    public static final String ERROR_DESCRIPTION = "HTTP response status code: %03d, error: '%s', reason: '%s'";

    @Message(id=1301, value="An error occurred increasing the value of the key")
    public HibernateException errorCalculatingNextValue(@Cause Exception var1);

    @Message(id=1302, value="An error occurred creating CouchDB Document, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorCreatingDocument(int var1, String var2, String var3);

    @Message(id=1303, value="An error occurred deleting CouchDB Document, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorDeletingDocument(int var1, String var2, String var3);

    @Message(id=1304, value="Unable to connect to CouchDB")
    public HibernateException couchDBConnectionProblem(@Cause Exception var1);

    @Message(id=1305, value="An error occurred dropping the database, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorDroppingDatabase(int var1, String var2, String var3);

    @Message(id=1306, value="An error occurred retrieving entity with id %s, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorRetrievingEntity(String var1, int var2, String var3, String var4);

    @Message(id=1307, value="An error occurred retrieving association with id %s, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorRetrievingAssociation(String var1, int var2, String var3, String var4);

    @Message(id=1308, value="An error occurred retrieving the number of associations stored in CouchDB, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException unableToRetrieveTheNumberOfAssociations(int var1, String var2, String var3);

    @Message(id=1309, value="An error occurred retrieving the number of entities stored in CouchDB, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException unableToRetrieveTheNumberOfEntities(int var1, String var2, String var3);

    @Message(id=1310, value="An error occurred retrieving tuples for table %s, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException unableToRetrieveTheTupleByEntityKeyMetadata(String var1, int var2, String var3, String var4);

    @Message(id=1311, value="An error occurred retrieving a key value, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorRetrievingKeyValue(int var1, String var2, String var3);

    @Message(id=1312, value="An error occurred retrieving the list of databases, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException unableToRetrieveTheListOfDatabase(int var1, String var2, String var3);

    @Message(id=1313, value="An error occurred retrieving database %s, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorCreatingDatabase(String var1, int var2, String var3, String var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1314, value="Connecting to CouchDB at %s")
    public void connectingToCouchDB(String var1);

    @Message(id=1315, value="An error occurred, malformed database URL. Database host: %s, database port: %03d, database name: %s")
    public HibernateException malformedDataBaseUrl(@Cause Exception var1, String var2, int var3, String var4);

    @Message(id=1317, value="Could not parse date string: %s")
    public HibernateException errorParsingStringToDate(@Cause ParseException var1, String var2);

    @Message(id=1318, value="Error shutting down the datastore")
    public HibernateException shutDownDatastoreException(@Cause Exception var1);

    @Message(id=1319, value="An error occurred when retrieving the current revision of entity with id %s, HTTP response status code: %03d, error: '%s', reason: '%s'")
    public HibernateException errorRetrievingCurrentRevision(String var1, int var2, String var3, String var4);

    @Message(id=1320, value="The document with id %s has been concurrently modified.")
    public OptimisticLockException getDocumentHasBeenConcurrentlyModifiedException(String var1);

    @Message(id=1321, value="Database %s does not exist. Either create it yourself or set property 'hibernate.ogm.datastore.create_database' to true.")
    public HibernateException databaseDoesNotExistException(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1322, value="Entity '%s' does not have a revision property; In order to make use of CouchDB's built-in optimistic locking mechanism, it is recommended to define a property '@Generated @Version String _rev'.")
    public void entityShouldHaveRevisionProperty(String var1);

    @Message(id=1323, value="CouchDB does not support multiple hosts configuration: %s")
    public HibernateException doesNotSupportMultipleHosts(String var1);
}

