/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.impl;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;

public class DefaultEntityKeyMetadata
implements EntityKeyMetadata {
    private final String table;
    private final int hashCode;
    private final String[] columnNames;

    public DefaultEntityKeyMetadata(String tableName, String[] columnNames) {
        this.table = tableName;
        this.columnNames = columnNames;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public boolean isKeyColumn(String columnName) {
        for (String keyColumName : this.getColumnNames()) {
            if (!keyColumName.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultEntityKeyMetadata");
        sb.append("{table='").append(this.table).append('\'');
        sb.append(", columnNames=").append(this.columnNames == null ? "null" : Arrays.asList(this.columnNames).toString());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || DefaultEntityKeyMetadata.class != o.getClass()) {
            return false;
        }
        DefaultEntityKeyMetadata entityKeyMetadata = (DefaultEntityKeyMetadata)o;
        if (!this.table.equals(entityKeyMetadata.table)) {
            return false;
        }
        return Arrays.equals(this.columnNames, entityKeyMetadata.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.table.hashCode();
        return result;
    }
}

