/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.source.impl;

import java.util.Arrays;
import java.util.List;
import org.hibernate.ogm.cfg.OptionConfigurator;
import org.hibernate.ogm.cfg.impl.ConfigurableImpl;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.options.navigation.impl.AppendableConfigurationContext;
import org.hibernate.ogm.options.navigation.source.impl.AnnotationOptionValueSource;
import org.hibernate.ogm.options.navigation.source.impl.ConfigurationOptionValueSource;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.options.navigation.source.impl.ProgrammaticOptionValueSource;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class OptionValueSources {
    private static final Log log = LoggerFactory.make();

    private OptionValueSources() {
    }

    public static List<OptionValueSource> getDefaultSources(ConfigurationPropertyReader propertyReader) {
        AppendableConfigurationContext programmaticOptions = (AppendableConfigurationContext)propertyReader.property("hibernate.ogm.options.context", AppendableConfigurationContext.class).instantiate().getValue();
        OptionConfigurator configurator = (OptionConfigurator)propertyReader.property("hibernate.ogm.option.configurator", OptionConfigurator.class).instantiate().getValue();
        if (configurator != null) {
            if (programmaticOptions != null) {
                throw log.ambigiousOptionConfiguration("hibernate.ogm.option.configurator");
            }
            programmaticOptions = OptionValueSources.invokeOptionConfigurator(configurator);
        }
        return programmaticOptions != null ? Arrays.asList(new ProgrammaticOptionValueSource(programmaticOptions), new AnnotationOptionValueSource(), new ConfigurationOptionValueSource(propertyReader)) : Arrays.asList(new AnnotationOptionValueSource(), new ConfigurationOptionValueSource(propertyReader));
    }

    private static <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> AppendableConfigurationContext invokeOptionConfigurator(OptionConfigurator configurator) {
        ConfigurableImpl configurable = new ConfigurableImpl();
        configurator.configure(configurable);
        return configurable.getContext();
    }
}

