/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.QueryTranslatorImpl;
import org.hibernate.hql.internal.ast.tree.SelectClause;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.loader.impl.OgmLoader;
import org.hibernate.ogm.loader.impl.OgmLoadingContext;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.type.Type;

public class OgmQueryLoader
extends QueryLoader {
    private final OgmQueryLoaderContext<?> loaderContext;
    private final boolean hasScalars;
    private final List<String> scalarColumns;
    private final Type[] queryReturnTypes;
    private final TypeTranslator typeTranslator;

    public OgmQueryLoader(QueryTranslatorImpl queryTranslator, SessionFactoryImplementor factory, SelectClause selectClause, BackendQuery<?> query, List<String> scalarColumns) {
        super(queryTranslator, factory, selectClause);
        this.loaderContext = OgmQueryLoader.getLoaderContext(query, factory);
        this.hasScalars = selectClause.isScalarSelect();
        this.scalarColumns = scalarColumns;
        this.queryReturnTypes = selectClause.getQueryReturnTypes();
        this.typeTranslator = (TypeTranslator)factory.getServiceRegistry().getService(TypeTranslator.class);
    }

    private static <T extends Serializable> OgmQueryLoaderContext<T> getLoaderContext(BackendQuery<?> query, SessionFactoryImplementor factory) {
        QueryableGridDialect gridDialect = (QueryableGridDialect)factory.getServiceRegistry().getService(QueryableGridDialect.class);
        return new OgmQueryLoaderContext(gridDialect, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<?> list(SessionImplementor session, QueryParameters queryParameters, Set<Serializable> querySpaces, Type[] resultTypes) throws HibernateException {
        try (ClosableIterator<Tuple> tuples = this.loaderContext.executeQuery(queryParameters);){
            if (this.hasScalars) {
                List<Object> list = this.listOfArrays(session, tuples);
                return list;
            }
            List<Object> list = this.listOfEntities(session, resultTypes, tuples);
            return list;
        }
    }

    private List<Object> listOfEntities(SessionImplementor session, Type[] resultTypes, ClosableIterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        Class returnedClass = resultTypes[0].getReturnedClass();
        while (tuples.hasNext()) {
            Tuple tuple = (Tuple)tuples.next();
            OgmLoader loader = this.createLoader(session, returnedClass);
            results.add(this.entity(session, tuple, loader));
        }
        return results;
    }

    private List<Object> listOfArrays(SessionImplementor session, Iterator<Tuple> tuples) {
        ArrayList<Object> results = new ArrayList<Object>();
        while (tuples.hasNext()) {
            Tuple tuple = tuples.next();
            Object[] entry = new Object[this.queryReturnTypes.length];
            int i = 0;
            for (Type type : this.queryReturnTypes) {
                GridType gridType = this.typeTranslator.getType(type);
                entry[i] = gridType.nullSafeGet(tuple, this.scalarColumns.get(i), session, null);
                ++i;
            }
            if (entry.length == 1) {
                results.add(entry[0]);
                continue;
            }
            results.add(entry);
        }
        return results;
    }

    private <E> E entity(SessionImplementor session, Tuple tuple, OgmLoader loader) {
        OgmLoadingContext ogmLoadingContext = new OgmLoadingContext();
        ogmLoadingContext.setTuples(Arrays.asList(tuple));
        List<Object> entities = loader.loadEntities(session, LockOptions.NONE, ogmLoadingContext);
        return (E)entities.get(0);
    }

    private OgmLoader createLoader(SessionImplementor session, Class<?> entityClass) {
        OgmEntityPersister persister = (OgmEntityPersister)session.getFactory().getEntityPersister(entityClass.getName());
        OgmLoader loader = new OgmLoader(new OgmEntityPersister[]{persister});
        return loader;
    }

    private static class OgmQueryLoaderContext<T extends Serializable> {
        private final QueryableGridDialect<T> gridDialect;
        private final BackendQuery<T> query;

        public OgmQueryLoaderContext(QueryableGridDialect<T> gridDialect, BackendQuery<T> query) {
            this.gridDialect = gridDialect;
            this.query = query;
        }

        public ClosableIterator<Tuple> executeQuery(QueryParameters queryParameters) {
            return this.gridDialect.executeBackendQuery(this.query, queryParameters);
        }
    }
}

