/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import java.util.Map;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.jpa.event.spi.JpaIntegrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.cfg.impl.Version;
import org.hibernate.ogm.datastore.impl.DatastoreProviderInitiator;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManager;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagerInitiator;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingAutoFlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingFlushEventListener;
import org.hibernate.ogm.dialect.eventstate.impl.EventContextManagingPersistEventListener;
import org.hibernate.ogm.dialect.impl.GridDialectInitiator;
import org.hibernate.ogm.dialect.impl.IdentityColumnAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.OgmDialectFactoryInitiator;
import org.hibernate.ogm.dialect.impl.OptimisticLockingAwareGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.QueryableGridDialectInitiator;
import org.hibernate.ogm.dialect.impl.SessionFactoryLifecycleAwareDialectInitializer;
import org.hibernate.ogm.jdbc.impl.OgmConnectionProviderInitiator;
import org.hibernate.ogm.jpa.impl.OgmPersisterClassResolverInitiator;
import org.hibernate.ogm.options.navigation.impl.OptionsServiceInitiator;
import org.hibernate.ogm.service.impl.OgmJdbcServicesInitiator;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.ogm.service.impl.SchemaDefiningObserver;
import org.hibernate.ogm.transaction.impl.OgmJtaPlatformInitiator;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactoryInitiator;
import org.hibernate.ogm.type.impl.TypeTranslatorInitiator;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class OgmIntegrator
implements Integrator,
ServiceContributingIntegrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(configuration, sessionFactory, serviceRegistry);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.doIntegrate(null, sessionFactory, serviceRegistry);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void prepareServices(StandardServiceRegistryBuilder serviceRegistryBuilder) {
        if (!this.isOgmUsed(serviceRegistryBuilder.getSettings())) {
            return;
        }
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmSessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmPersisterClassResolverInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmConnectionProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmDialectFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmTransactionFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJtaPlatformInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OgmJdbcServicesInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)DatastoreProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptionsServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)TypeTranslatorInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)GridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)QueryableGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)IdentityColumnAwareGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)OptimisticLockingAwareGridDialectInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((StandardServiceInitiator)EventContextManagerInitiator.INSTANCE);
    }

    private void doIntegrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!this.isOgmUsed(configuration.getProperties())) {
            return;
        }
        Version.touch();
        sessionFactory.addObserver((SessionFactoryObserver)new SchemaDefiningObserver(configuration));
        sessionFactory.addObserver((SessionFactoryObserver)new SessionFactoryLifecycleAwareDialectInitializer());
        this.attachEventContextManagingListenersIfRequired(configuration, serviceRegistry);
    }

    private boolean isOgmUsed(Map properties) {
        return new ConfigurationPropertyReader(properties).property("hibernate.ogm._activate", Boolean.TYPE).withDefault(false).getValue();
    }

    private void attachEventContextManagingListenersIfRequired(Configuration configuration, SessionFactoryServiceRegistry serviceRegistry) {
        if (!EventContextManager.isEventContextRequired(configuration.getProperties(), serviceRegistry)) {
            return;
        }
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        EventContextManager stateManager = (EventContextManager)serviceRegistry.getService(EventContextManager.class);
        eventListenerRegistry.addDuplicationStrategy(EventContextManagingAutoFlushEventListener.EventContextManagingAutoFlushEventListenerDuplicationStrategy.INSTANCE);
        eventListenerRegistry.getEventListenerGroup(EventType.AUTO_FLUSH).appendListener((Object)new EventContextManagingAutoFlushEventListener(stateManager));
        eventListenerRegistry.addDuplicationStrategy(EventContextManagingFlushEventListener.EventContextManagingFlushEventListenerDuplicationStrategy.INSTANCE);
        eventListenerRegistry.getEventListenerGroup(EventType.FLUSH).appendListener((Object)new EventContextManagingFlushEventListener(stateManager));
        if (this.getIntegrator(JpaIntegrator.class, serviceRegistry) != null) {
            eventListenerRegistry.addDuplicationStrategy(EventContextManagingPersistEventListener.EventContextManagingPersistEventListenerDuplicationStrategy.INSTANCE);
            eventListenerRegistry.getEventListenerGroup(EventType.PERSIST).appendListener((Object)new EventContextManagingPersistEventListener(stateManager));
        }
    }

    private <T extends Integrator> T getIntegrator(Class<T> integratorType, SessionFactoryServiceRegistry serviceRegistry) {
        Iterable integrators = ((IntegratorService)serviceRegistry.getService(IntegratorService.class)).getIntegrators();
        for (Integrator integrator : integrators) {
            if (!integratorType.isInstance(integrator)) continue;
            return (T)integrator;
        }
        return null;
    }
}

