/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.transaction.internal.jdbc.JdbcIsolationDelegate;
import org.hibernate.engine.transaction.spi.AbstractTransactionImpl;
import org.hibernate.engine.transaction.spi.IsolationDelegate;
import org.hibernate.engine.transaction.spi.JoinStatus;
import org.hibernate.engine.transaction.spi.LocalStatus;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class EmulatedLocalTransaction
extends AbstractTransactionImpl {
    private static final Log log = LoggerFactory.make();
    private boolean isDriver;

    protected EmulatedLocalTransaction(TransactionCoordinator transactionCoordinator) {
        super(transactionCoordinator);
    }

    protected void doBegin() {
        this.isDriver = this.transactionCoordinator().takeOwnership();
    }

    protected void afterTransactionBegin() {
        this.transactionCoordinator().sendAfterTransactionBeginNotifications((TransactionImplementor)this);
        if (this.isDriver) {
            this.transactionCoordinator().getTransactionContext().afterTransactionBegin((TransactionImplementor)this);
        }
    }

    protected void beforeTransactionCommit() {
        this.transactionCoordinator().sendBeforeTransactionCompletionNotifications((TransactionImplementor)this);
        if (this.isDriver && !this.transactionCoordinator().getTransactionContext().isFlushModeNever()) {
            this.transactionCoordinator().getTransactionContext().managedFlush();
        }
        if (this.isDriver) {
            this.transactionCoordinator().getTransactionContext().beforeTransactionCompletion((TransactionImplementor)this);
        }
    }

    protected void doCommit() throws TransactionException {
    }

    protected void afterTransactionCompletion(int status) {
        this.transactionCoordinator().afterTransaction((TransactionImplementor)this, status);
    }

    protected void afterAfterCompletion() {
        if (this.isDriver && this.transactionCoordinator().getTransactionContext().shouldAutoClose() && !this.transactionCoordinator().getTransactionContext().isClosed()) {
            try {
                this.transactionCoordinator().getTransactionContext().managedClose();
            }
            catch (HibernateException e) {
                log.unableToCloseSessionButSwallowingError((Exception)((Object)e));
            }
        }
    }

    protected void beforeTransactionRollBack() {
    }

    protected void doRollback() throws TransactionException {
    }

    public boolean isInitiator() {
        return true;
    }

    public IsolationDelegate createIsolationDelegate() {
        return new JdbcIsolationDelegate(this.transactionCoordinator());
    }

    public JoinStatus getJoinStatus() {
        return this.isActive() ? JoinStatus.JOINED : JoinStatus.NOT_JOINED;
    }

    public void markRollbackOnly() {
    }

    public void join() {
    }

    public void resetJoinStatus() {
    }

    public boolean isActive() throws HibernateException {
        return this.getLocalStatus() == LocalStatus.ACTIVE;
    }
}

