/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.spi.TransactionImplementor;
import org.hibernate.ogm.compensation.ErrorHandler;
import org.hibernate.ogm.compensation.impl.OperationCollector;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionImplementor;

public class ErrorHandlerEnabledTransactionDecorator
extends ForwardingTransactionImplementor {
    private final JtaPlatform jtaPlatform;
    private ErrorHandler errorHandler;
    private OperationCollector operationCollector;
    private boolean callErrorHandlerOnRollback;

    public ErrorHandlerEnabledTransactionDecorator(TransactionImplementor delegate, ErrorHandler errorHandler, JtaPlatform jtaPlatform) {
        super(delegate);
        this.jtaPlatform = jtaPlatform;
        this.errorHandler = errorHandler;
        this.operationCollector = new OperationCollector(errorHandler);
        this.callErrorHandlerOnRollback = true;
    }

    public void begin(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.operationCollector = new OperationCollector(errorHandler);
        super.begin();
    }

    @Override
    public void rollback() {
        if (this.callErrorHandlerOnRollback) {
            this.errorHandler.onRollback(this.operationCollector);
        }
        super.rollback();
    }

    public OperationCollector getOperationCollector() {
        return this.operationCollector;
    }

    @Override
    public void join() {
        boolean jtaTransactionActive;
        boolean synchronizationAlreadyRegistered = !this.callErrorHandlerOnRollback;
        boolean bl = jtaTransactionActive = this.jtaPlatform != null && JtaStatusHelper.isActive((TransactionManager)this.jtaPlatform.retrieveTransactionManager());
        if (jtaTransactionActive && !synchronizationAlreadyRegistered) {
            this.jtaPlatform.registerSynchronization((Synchronization)new ErrorHandlerNotificationSynchronization());
            this.callErrorHandlerOnRollback = false;
        }
        super.join();
    }

    private class ErrorHandlerNotificationSynchronization
    implements Synchronization {
        private ErrorHandlerNotificationSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (4 == status) {
                ErrorHandlerEnabledTransactionDecorator.this.errorHandler.onRollback(ErrorHandlerEnabledTransactionDecorator.this.operationCollector);
            }
        }
    }
}

