/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.model.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.cassandra.model.impl.ResultSetTupleSnapshot;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class ResultSetAssociationSnapshot
implements AssociationSnapshot {
    private Map<RowKey, Row> res = new HashMap<RowKey, Row>();
    private ProtocolVersion protocolVersion;

    public ResultSetAssociationSnapshot(AssociationKey key, ResultSet resultSet, Table tableMetadata, ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        if (resultSet == null) {
            this.res = Collections.EMPTY_MAP;
            return;
        }
        LinkedList<String> combinedKeys = new LinkedList<String>();
        combinedKeys.addAll(Arrays.asList(key.getColumnNames()));
        for (Object column : tableMetadata.getPrimaryKey().getColumns()) {
            String name = ((Column)column).getName();
            if (combinedKeys.contains(name)) continue;
            combinedKeys.add(name);
        }
        String[] columnNames = combinedKeys.toArray(new String[combinedKeys.size()]);
        for (Row row : resultSet) {
            Object[] columnValues = new Object[columnNames.length];
            for (int i = 0; i < columnNames.length; ++i) {
                DataType dataType = row.getColumnDefinitions().getType(columnNames[i]);
                columnValues[i] = dataType.deserialize(row.getBytesUnsafe(columnNames[i]), protocolVersion);
            }
            RowKey rowKey = new RowKey(columnNames, columnValues);
            this.res.put(rowKey, row);
        }
    }

    public Tuple get(RowKey rowKey) {
        return new Tuple((TupleSnapshot)new ResultSetTupleSnapshot(this.res.get(rowKey), this.protocolVersion));
    }

    public boolean containsKey(RowKey rowKey) {
        return this.res.containsKey(rowKey);
    }

    public int size() {
        return this.res.size();
    }

    public Set<RowKey> getRowKeys() {
        return this.res.keySet();
    }
}

