/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.cassandra.model.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public class ResultSetTupleSnapshot
implements TupleSnapshot {
    private final Row row;
    private Map<String, Integer> columnNames = new HashMap<String, Integer>();
    private ProtocolVersion protocolVersion;

    public ResultSetTupleSnapshot(Row row, ProtocolVersion protocolVersion) {
        this.row = row;
        this.protocolVersion = protocolVersion;
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        int count = columnDefinitions.size();
        for (int index = 0; index < count; ++index) {
            this.columnNames.put(columnDefinitions.getName(index), index);
        }
    }

    public Object get(String column) {
        Integer index = this.columnNames.get(column);
        DataType dataType = this.row.getColumnDefinitions().getType(index.intValue());
        ByteBuffer byteBuffer = this.row.getBytesUnsafe(index.intValue());
        if (byteBuffer == null) {
            return null;
        }
        Object value = dataType.deserialize(byteBuffer, this.protocolVersion);
        return value;
    }

    public boolean isEmpty() {
        return this.columnNames.isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.columnNames.keySet();
    }
}

