/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.table.externalizer.impl;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.AssociationKey;

public class PersistentAssociationKey {
    private final String[] columnNames;
    private final Object[] columnValues;

    public PersistentAssociationKey(String[] columnNames, Object[] columnValues) {
        this.columnNames = columnNames;
        this.columnValues = columnValues;
    }

    public static PersistentAssociationKey fromAssociationKey(AssociationKey key) {
        return new PersistentAssociationKey(key.getColumnNames(), key.getColumnValues());
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistentAssociationKey other = (PersistentAssociationKey)obj;
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        return Arrays.equals(this.columnValues, other.columnValues);
    }

    public String toString() {
        return "PersistentAssociationKey [columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + "]";
    }
}

