/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl.configuration;

import com.mongodb.MongoClientOptions;
import com.mongodb.WriteConcern;
import java.util.Locale;
import java.util.Map;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.mongodb.impl.configuration.Environment;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;

public class MongoDBConfiguration {
    private static final Log log = LoggerFactory.getLogger();
    private String host;
    private int port;
    private AssociationStorage associationStorage;
    private String databaseName;
    private String username;
    private String password;
    private int timeout;
    private WriteConcern writeConcern;

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public AssociationStorage getAssociationStorage() {
        return this.associationStorage;
    }

    public int getPort() {
        return this.port;
    }

    public void initialize(Map configurationMap) {
        this.host = this.buildHost(configurationMap);
        this.port = this.buildPort(configurationMap);
        this.timeout = this.buildTimeout(configurationMap);
        log.connectingToMongo(this.host, this.port, this.timeout);
        this.associationStorage = this.buildAssociationStorage(configurationMap);
        this.writeConcern = this.buildWriteConcern(configurationMap);
        this.databaseName = this.buildDatabase(configurationMap);
        this.username = this.buildUsername(configurationMap);
        this.password = this.buildPassword(configurationMap);
    }

    private String buildHost(Map<?, ?> cfg) {
        Object cfgHost = cfg.get("hibernate.ogm.mongodb.host");
        return cfgHost != null ? cfgHost.toString() : "127.0.0.1";
    }

    private int buildPort(Map<?, ?> cfg) {
        Object cfgPort = cfg.get("hibernate.ogm.mongodb.port");
        if (cfgPort != null) {
            try {
                int temporaryPort = Integer.valueOf(cfgPort.toString());
                if (temporaryPort < 1 || temporaryPort > 65535) {
                    throw log.mongoPortIllegalValue(cfgPort.toString());
                }
                return temporaryPort;
            }
            catch (NumberFormatException e) {
                throw log.mongoPortIllegalValue(cfgPort.toString());
            }
        }
        return 27017;
    }

    private AssociationStorage buildAssociationStorage(Map<?, ?> cfg) {
        String assocStoreString = (String)cfg.get("hibernate.ogm.mongodb.associations.store");
        if (assocStoreString == null) {
            return AssociationStorage.IN_ENTITY;
        }
        try {
            return AssociationStorage.valueOf(assocStoreString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw log.unknownAssociationStorageStrategy(assocStoreString, AssociationStorage.class);
        }
    }

    private WriteConcern buildWriteConcern(Map<?, ?> cfg) {
        Object cfgWriteConcern = cfg.get("hibernate.ogm.mongodb.writeconcern");
        WriteConcern writeConcern = Environment.MONGODB_DEFAULT_WRITE_CONCERN;
        String wcLogMessage = "ACKNOWLEDGED";
        if (cfgWriteConcern != null) {
            String confWC = cfgWriteConcern.toString();
            writeConcern = WriteConcern.valueOf((String)confWC);
            if (writeConcern == null) {
                writeConcern = Environment.MONGODB_DEFAULT_WRITE_CONCERN;
                wcLogMessage = "ACKNOWLEDGED";
            } else {
                wcLogMessage = confWC;
            }
        }
        log.useWriteConcern(wcLogMessage);
        return writeConcern;
    }

    private int buildTimeout(Map<?, ?> cfg) {
        Object cfgTimeout = cfg.get("hibernate.ogm.mongodb.connection_timeout");
        if (cfgTimeout != null) {
            try {
                int temporaryTimeout = Integer.valueOf(cfgTimeout.toString());
                if (temporaryTimeout < 0) {
                    throw log.mongoDBTimeOutIllegalValue(cfgTimeout.toString());
                }
                return temporaryTimeout;
            }
            catch (NumberFormatException e) {
                throw log.mongoDBTimeOutIllegalValue(cfgTimeout.toString());
            }
        }
        return 5000;
    }

    private String buildDatabase(Map<?, ?> cfg) {
        Object dbNameObject = cfg.get("hibernate.ogm.mongodb.database");
        if (dbNameObject == null) {
            throw log.mongoDbNameMissing();
        }
        String dbName = (String)dbNameObject;
        log.connectingToMongoDatabase(dbName);
        return dbName;
    }

    private String buildUsername(Map<?, ?> cfg) {
        return (String)cfg.get("hibernate.ogm.mongodb.username");
    }

    private String buildPassword(Map<?, ?> cfg) {
        Object passwordObject = cfg.get("hibernate.ogm.mongodb.password");
        return passwordObject != null ? passwordObject.toString() : "";
    }

    public MongoClientOptions buildOptions() {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.connectTimeout(this.timeout);
        optionsBuilder.writeConcern(this.writeConcern);
        return optionsBuilder.build();
    }
}

