/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoDBTupleSnapshot;
import org.hibernate.ogm.dialect.mongodb.MongoHelpers;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;

public class MongoDBAssociationSnapshot
implements AssociationSnapshot {
    private final Map<RowKey, DBObject> map;
    private final DBObject dbObject;
    private AssociationKey associationKey;
    private AssociationStorage storage;

    public MongoDBAssociationSnapshot(DBObject document, AssociationKey key, AssociationStorage storage) {
        this.storage = storage;
        this.dbObject = document;
        this.map = new LinkedHashMap<RowKey, DBObject>();
        this.associationKey = key;
        Iterator<DBObject> i$ = this.getRows().iterator();
        while (i$.hasNext()) {
            DBObject row;
            DBObject mongodbColumnData = row = i$.next();
            List<String> columnNames = Arrays.asList(key.getRowKeyColumnNames());
            ArrayList<Object> columnValues = new ArrayList<Object>();
            for (String columnKey : columnNames) {
                boolean getFromMongoData = true;
                int length = key.getColumnNames().length;
                for (int index = 0; index < length; ++index) {
                    String assocColumn = key.getColumnNames()[index];
                    if (!assocColumn.equals(columnKey)) continue;
                    columnValues.add(this.associationKey.getColumnValues()[index]);
                    getFromMongoData = false;
                    break;
                }
                if (!getFromMongoData) continue;
                columnValues.add(mongodbColumnData.get(columnKey));
            }
            RowKey rowKey = new RowKey(key.getTable(), columnNames.toArray(new String[columnNames.size()]), columnValues.toArray());
            this.map.put(rowKey, row);
        }
    }

    public Tuple get(RowKey column) {
        DBObject row = this.map.get(column);
        return row == null ? null : new Tuple((TupleSnapshot)new MongoDBTupleSnapshot(row, column));
    }

    public DBObject getQueryObject() {
        BasicDBObject query = new BasicDBObject();
        query.put("_id", this.dbObject.get("_id"));
        return query;
    }

    public boolean containsKey(RowKey column) {
        return this.map.containsKey(column);
    }

    public int size() {
        return this.map.size();
    }

    private Collection<DBObject> getRows() {
        if (MongoHelpers.isEmbeddedInEntity(this.associationKey, this.storage)) {
            return MongoHelpers.getAssociationFieldOrNull(this.associationKey, this.dbObject);
        }
        return (Collection)this.dbObject.get("rows");
    }

    public DBObject getRowKeyDBObject(RowKey rowKey) {
        return this.map.get(rowKey);
    }

    public Set<RowKey> getRowKeys() {
        return this.map.keySet();
    }

    public DBObject getDBObject() {
        return this.dbObject;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MongoDBAssociationSnapshot(");
        sb.append(this.map.size());
        sb.append(") RowKey entries).");
        return sb.toString();
    }
}

