/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.query.parsing.predicate;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;

public class MongoDBComparisonPredicate
extends ComparisonPredicate<DBObject>
implements NegatablePredicate<DBObject> {
    public MongoDBComparisonPredicate(String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
    }

    protected DBObject getStrictlyLessQuery() {
        return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$lt", this.value));
    }

    protected DBObject getLessOrEqualsQuery() {
        return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$lte", this.value));
    }

    protected DBObject getEqualsQuery() {
        return new BasicDBObject(this.propertyName, this.value);
    }

    protected DBObject getGreaterOrEqualsQuery() {
        return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$gte", this.value));
    }

    protected DBObject getStrictlyGreaterQuery() {
        return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$gt", this.value));
    }

    public DBObject getNegatedQuery() {
        switch (this.type) {
            case LESS: {
                return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$gte", this.value));
            }
            case LESS_OR_EQUAL: {
                return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$gt", this.value));
            }
            case EQUALS: {
                return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$ne", this.value));
            }
            case GREATER_OR_EQUAL: {
                return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$lt", this.value));
            }
            case GREATER: {
                return new BasicDBObject(this.propertyName, (Object)new BasicDBObject("$lte", this.value));
            }
        }
        throw new UnsupportedOperationException("Unsupported comparison type: " + this.type);
    }
}

