/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.dialect.impl;

import com.mongodb.DBObject;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.EntityKeyMetadata;

public class MassIndexingMongoDBTupleSnapshot
implements TupleSnapshot {
    private final DBObject dbObject;
    private final EntityKeyMetadata entityKeyMetadata;

    public MassIndexingMongoDBTupleSnapshot(DBObject dbObject, EntityKeyMetadata entityKeyMetadata) {
        this.dbObject = dbObject;
        this.entityKeyMetadata = entityKeyMetadata;
    }

    public Object get(String column) {
        if (this.columnInIdField(column)) {
            if (column.contains(".")) {
                int dotIndex = column.indexOf(".");
                String shortColumnName = column.substring(dotIndex + 1);
                DBObject idObject = (DBObject)this.dbObject.get("_id");
                return idObject.get(shortColumnName);
            }
            return this.dbObject.get("_id");
        }
        return this.dbObject.get(column);
    }

    public boolean isEmpty() {
        return this.dbObject.keySet().isEmpty();
    }

    public Set<String> getColumnNames() {
        return this.dbObject.keySet();
    }

    public boolean columnInIdField(String column) {
        for (String idColumn : this.entityKeyMetadata.getColumnNames()) {
            if (!idColumn.equals(column)) continue;
            return true;
        }
        return false;
    }
}

