/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.logging.impl;

import com.mongodb.MongoException;
import org.hibernate.HibernateException;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends org.hibernate.ogm.util.impl.Log {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1201, value="Connecting to MongoDB at %1$s:%2$d with a timeout set at %3$d millisecond(s)")
    public void connectingToMongo(String var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1202, value="Closing connection to MongoDB")
    public void disconnectingFromMongo();

    @Message(id=1203, value="Unable to find or initialize a connection to the MongoDB server")
    public HibernateException unableToInitializeMongoDB(@Cause RuntimeException var1);

    @Message(id=1205, value="Could not resolve MongoDB hostname [%s]")
    public HibernateException mongoOnUnknownHost(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1206, value="Mongo database named [%s] is not defined. Creating it!")
    public void creatingDatabase(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1207, value="Connecting to Mongo database named [%s].")
    public void connectingToMongoDatabase(String var1);

    @Message(id=1209, value="The database named [%s] cannot be dropped")
    public HibernateException unableToDropDatabase(@Cause MongoException var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=1210, value="Removed [%d] associations")
    public void removedAssociation(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1211, value="Using write concern { w : %s, wtimeout : %s, fsync : %s, journaled : %s, continueOnErrorForInsert : %s } if not explicitly configured otherwise for specific entities")
    public void usingWriteConcern(String var1, int var2, boolean var3, boolean var4, boolean var5);

    @Message(id=1213, value="MongoDB authentication failed with username [%s]")
    public HibernateException authenticationFailed(String var1);

    @Message(id=1214, value="Unable to connect to MongoDB instance %1$s:%2$d")
    public HibernateException unableToConnectToDatastore(String var1, int var2, @Cause Exception var3);

    @Message(id=1215, value="The value set for the configuration propertyhibernate.ogm.mongodb.connection_timeout must be a number greater than 0. Found '[%s]'.")
    public HibernateException mongoDBTimeOutIllegalValue(int var1);

    @Message(id=1217, value="The following native query does neither specify the collection name nor is its result type mapped to an entity: %s")
    public HibernateException unableToDetermineCollectionName(String var1);

    @Message(id=1218, value="Cannot use primary key column name '%s' for id generator, going to use '%s' instead")
    public HibernateException cannotUseGivenPrimaryKeyColumnName(String var1, String var2);
}

