/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.ogm.datastore.mongodb.query.impl.MongoDBQueryDescriptor;
import org.hibernate.ogm.query.spi.QueryParsingResult;

public class MongoDBQueryParsingResult
implements QueryParsingResult {
    private final Class<?> entityType;
    private final String collectionName;
    private final DBObject query;
    private final DBObject projection;
    private final DBObject orderBy;

    public MongoDBQueryParsingResult(Class<?> entityType, String collectionName, DBObject query, DBObject projection, DBObject orderBy) {
        this.entityType = entityType;
        this.collectionName = collectionName;
        this.query = query;
        this.projection = projection;
        this.orderBy = orderBy;
    }

    public DBObject getQuery() {
        return this.query;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public DBObject getProjection() {
        return this.projection;
    }

    public DBObject getOrderBy() {
        return this.orderBy;
    }

    public Object getQueryObject() {
        return new MongoDBQueryDescriptor(this.collectionName, MongoDBQueryDescriptor.Operation.FIND, this.query, this.projection, this.orderBy);
    }

    public List<String> getColumnNames() {
        return this.projection != null ? new ArrayList(this.projection.keySet()) : Collections.emptyList();
    }

    public String toString() {
        return "MongoDBQueryParsingResult [entityType=" + this.entityType.getSimpleName() + ", query=" + this.query + ", projection=" + this.projection + "]";
    }
}

