/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.origin.hql.resolve.path.PathedPropertyReferenceSource;
import org.hibernate.hql.ast.origin.hql.resolve.path.PropertyPath;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.hibernate.hql.ast.spi.SingleEntityQueryBuilder;
import org.hibernate.hql.ast.spi.SingleEntityQueryRendererDelegate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPredicateFactory;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class MongoDBQueryRendererDelegate
extends SingleEntityQueryRendererDelegate<DBObject, MongoDBQueryParsingResult> {
    private final SessionFactoryImplementor sessionFactory;
    private final MongoDBPropertyHelper propertyHelper;
    private DBObject orderBy;

    public MongoDBQueryRendererDelegate(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, MongoDBPropertyHelper propertyHelper, Map<String, Object> namedParameters) {
        super(entityNames, SingleEntityQueryBuilder.getInstance((PredicateFactory)new MongoDBPredicateFactory(propertyHelper), (PropertyHelper)propertyHelper), namedParameters);
        this.sessionFactory = sessionFactory;
        this.propertyHelper = propertyHelper;
    }

    public MongoDBQueryParsingResult getResult() {
        OgmEntityPersister entityPersister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(this.targetType.getName());
        return new MongoDBQueryParsingResult(this.targetType, entityPersister.getTableName(), (DBObject)this.builder.build(), this.getProjectionDBObject(), this.orderBy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyPath(PropertyPath propertyPath) {
        if (this.status == SingleEntityQueryRendererDelegate.Status.DEFINING_SELECT) {
            if (propertyPath.getNodes().size() == 1 && !propertyPath.getLastNode().isAlias() || propertyPath.getNodes().size() == 2 && ((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) {
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, propertyPath.asStringPathWithoutAlias()));
                return;
            } else {
                if (propertyPath.getNodes().size() <= 2 || !((PathedPropertyReferenceSource)propertyPath.getNodes().get(0)).isAlias()) return;
                if (!this.propertyHelper.isEmbedddedProperty(this.targetTypeName, propertyPath)) throw new UnsupportedOperationException("Selecting associated properties not yet implemented.");
                this.projections.add(this.propertyHelper.getColumnName(this.targetTypeName, propertyPath.asStringPathWithoutAlias()));
            }
            return;
        } else {
            this.propertyPath = propertyPath;
        }
    }

    private DBObject getProjectionDBObject() {
        if (this.projections.isEmpty()) {
            return null;
        }
        BasicDBObject projectionDBObject = new BasicDBObject();
        for (String projection : this.projections) {
            projectionDBObject.put(projection, (Object)1);
        }
        return projectionDBObject;
    }

    protected void addSortField(PropertyPath propertyPath, String collateName, boolean isAscending) {
        if (this.orderBy == null) {
            this.orderBy = new BasicDBObject();
        }
        String columnName = this.propertyHelper.getColumnName(this.targetType, propertyPath.asStringPathWithoutAlias());
        this.orderBy.put(columnName, (Object)(isAscending ? 1 : -1));
    }
}

