/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import org.hibernate.ogm.datastore.mongodb.logging.impl.Log;
import org.hibernate.ogm.datastore.mongodb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.SchemaDefiner;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.persister.entity.EntityPersister;

public class MongoDBEntityMappingValidator
extends BaseSchemaDefiner {
    private static final Log log = LoggerFactory.getLogger();

    public void validateMapping(SchemaDefiner.SchemaDefinitionContext context) {
        this.validateGenerators(context.getAllIdSourceKeyMetadata());
        this.validateEntityCollectionNames(context.getAllEntityKeyMetadata());
        this.validateAssociationNames(context.getAllAssociationKeyMetadata());
        this.validateAllPersisters(context.getSessionFactory().getEntityPersisters().values());
    }

    private void validateAllPersisters(Iterable<EntityPersister> persisters) {
        for (EntityPersister persister : persisters) {
            if (!(persister instanceof OgmEntityPersister)) continue;
            OgmEntityPersister ogmPersister = (OgmEntityPersister)persister;
            int propertySpan = ogmPersister.getEntityMetamodel().getPropertySpan();
            for (int i = 0; i < propertySpan; ++i) {
                String[] columnNames;
                for (String columnName : columnNames = ogmPersister.getPropertyColumnNames(i)) {
                    this.validateAsMongoDBFieldName(columnName);
                }
            }
        }
    }

    private void validateAssociationNames(Iterable<AssociationKeyMetadata> allAssociationKeyMetadata) {
        for (AssociationKeyMetadata associationKeyMetadata : allAssociationKeyMetadata) {
            MongoDBEntityMappingValidator.validateAsMongoDBCollectionName(associationKeyMetadata.getTable());
            for (String column : associationKeyMetadata.getRowKeyColumnNames()) {
                this.validateAsMongoDBFieldName(column);
            }
        }
    }

    private void validateEntityCollectionNames(Iterable<EntityKeyMetadata> allEntityKeyMetadata) {
        for (EntityKeyMetadata entityKeyMetadata : allEntityKeyMetadata) {
            MongoDBEntityMappingValidator.validateAsMongoDBCollectionName(entityKeyMetadata.getTable());
            for (String column : entityKeyMetadata.getColumnNames()) {
                this.validateAsMongoDBFieldName(column);
            }
        }
    }

    private void validateGenerators(Iterable<IdSourceKeyMetadata> allIdSourceKeyMetadata) {
        for (IdSourceKeyMetadata idSourceKeyMetadata : allIdSourceKeyMetadata) {
            String keyColumn = idSourceKeyMetadata.getKeyColumnName();
            if (keyColumn.equals("_id")) continue;
            log.cannotUseGivenPrimaryKeyColumnName(keyColumn, "_id");
        }
    }

    private static void validateAsMongoDBCollectionName(String collectionName) {
        Contracts.assertStringParameterNotEmpty((String)collectionName, (String)"requestedName");
        if (collectionName.startsWith("system.")) {
            throw log.collectionNameHasInvalidSystemPrefix(collectionName);
        }
        if (collectionName.contains("\u0000")) {
            throw log.collectionNameContainsNULCharacter(collectionName);
        }
        if (collectionName.contains("$")) {
            throw log.collectionNameContainsDollarCharacter(collectionName);
        }
    }

    private void validateAsMongoDBFieldName(String fieldName) {
        if (fieldName.startsWith("$")) {
            throw log.fieldNameHasInvalidDollarPrefix(fieldName);
        }
        if (fieldName.contains("\u0000")) {
            throw log.fieldNameContainsNULCharacter(fieldName);
        }
    }
}

