/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.bson.Document;

public class MongoDBQueryDescriptor
implements Serializable {
    private final String collectionName;
    private final Operation operation;
    private final Document criteria;
    private final Document projection;
    private final String distinctFieldName;
    private final String mapFunction;
    private final String reduceFunction;
    private final Document updateOrInsertOne;
    private final List<Document> updateOrInsertMany;
    private final Document orderBy;
    private final Document options;
    private final List<String> unwinds;
    private final List<Document> pipeline;

    public MongoDBQueryDescriptor(String collectionName, Operation operation, List<Document> pipeline) {
        this.collectionName = collectionName;
        this.operation = operation;
        this.criteria = null;
        this.projection = null;
        this.orderBy = null;
        this.options = null;
        this.updateOrInsertOne = null;
        this.updateOrInsertMany = null;
        this.unwinds = null;
        this.pipeline = pipeline == null ? Collections.emptyList() : pipeline;
        this.distinctFieldName = null;
        this.mapFunction = null;
        this.reduceFunction = null;
    }

    public MongoDBQueryDescriptor(String collectionName, Operation operation, Document criteria, Document projection, Document orderBy, Document options, Document updateOrInsertOne, List<Document> updateOrInsertMany, List<String> unwinds, String distinctFieldName, String mapFunction, String reduceFunction) {
        this.collectionName = collectionName;
        this.operation = operation;
        this.criteria = criteria;
        this.projection = projection;
        this.orderBy = orderBy;
        this.options = options;
        this.updateOrInsertOne = updateOrInsertOne;
        this.updateOrInsertMany = updateOrInsertMany;
        this.unwinds = unwinds;
        this.pipeline = Collections.emptyList();
        this.distinctFieldName = distinctFieldName;
        this.mapFunction = mapFunction;
        this.reduceFunction = reduceFunction;
    }

    public List<Document> getPipeline() {
        return this.pipeline;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Document getCriteria() {
        return this.criteria;
    }

    public Document getProjection() {
        return this.projection;
    }

    public Document getOrderBy() {
        return this.orderBy;
    }

    public Document getOptions() {
        return this.options;
    }

    public Document getUpdateOrInsertOne() {
        return this.updateOrInsertOne;
    }

    public List<Document> getUpdateOrInsertMany() {
        return this.updateOrInsertMany;
    }

    public List<String> getUnwinds() {
        return this.unwinds;
    }

    public String getDistinctFieldName() {
        return this.distinctFieldName;
    }

    public String getMapFunction() {
        return this.mapFunction;
    }

    public String getReduceFunction() {
        return this.reduceFunction;
    }

    public String toString() {
        return String.format("MongoDBQueryDescriptor [collectionName=%s, %s=%s, %s=%s, %s%s]", this.collectionName, this.operation == Operation.FINDANDMODIFY ? "document" : (this.operation == Operation.INSERT ? "document(s)" : "where"), this.criteria, this.operation == Operation.UPDATE ? "update" : (this.operation == Operation.INSERT ? "insert" : (this.operation == Operation.REMOVE ? "remove" : "projection")), this.projection, this.operation == Operation.UPDATE || this.operation == Operation.INSERT || this.operation == Operation.REMOVE ? "" : "options=", this.options);
    }

    public static enum Operation {
        FIND,
        FINDONE,
        FINDANDMODIFY,
        INSERT,
        INSERTONE,
        INSERTMANY,
        REMOVE,
        DELETEONE,
        DELETEMANY,
        UPDATE,
        UPDATEONE,
        UPDATEMANY,
        REPLACEONE,
        COUNT,
        AGGREGATE,
        AGGREGATE_PIPELINE,
        DISTINCT,
        MAP_REDUCE;

    }
}

