/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.query.parsing.impl;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.QueryRendererDelegate;
import org.hibernate.hql.ast.spi.QueryRendererProcessor;
import org.hibernate.hql.ast.spi.QueryResolverDelegate;
import org.hibernate.hql.ast.spi.QueryResolverProcessor;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBPropertyHelper;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryParsingResult;
import org.hibernate.ogm.datastore.mongodb.query.parsing.impl.MongoDBQueryRendererDelegate;
import org.hibernate.ogm.query.parsing.impl.HibernateOGMQueryResolverDelegate;

public class MongoDBProcessingChain
implements AstProcessingChain<MongoDBQueryParsingResult> {
    private final QueryResolverProcessor resolverProcessor = new QueryResolverProcessor((QueryResolverDelegate)new HibernateOGMQueryResolverDelegate());
    private final QueryRendererProcessor rendererProcessor;
    private final MongoDBQueryRendererDelegate rendererDelegate;

    public MongoDBProcessingChain(SessionFactoryImplementor sessionFactory, EntityNamesResolver entityNames, Map<String, Object> namedParameters) {
        MongoDBPropertyHelper propertyHelper = new MongoDBPropertyHelper(sessionFactory, entityNames);
        MongoDBQueryRendererDelegate rendererDelegate = new MongoDBQueryRendererDelegate(sessionFactory, entityNames, propertyHelper, namedParameters);
        this.rendererProcessor = new QueryRendererProcessor((QueryRendererDelegate)rendererDelegate);
        this.rendererDelegate = rendererDelegate;
    }

    public Iterator<AstProcessor> iterator() {
        return Arrays.asList(this.resolverProcessor, this.rendererProcessor).iterator();
    }

    public MongoDBQueryParsingResult getResult() {
        return this.rendererDelegate.getResult();
    }
}

