/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.Document;
import org.hibernate.ogm.datastore.mongodb.type.AbstractGeoJsonObject;
import org.hibernate.ogm.datastore.mongodb.type.GeoLineString;
import org.hibernate.ogm.util.Experimental;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.ogm.util.impl.Contracts;

@Experimental
public class GeoMultiLineString
extends AbstractGeoJsonObject {
    public static final String TYPE = "MultiLineString";
    private List<GeoLineString> lineStrings;

    public GeoMultiLineString(List<GeoLineString> lineStrings) {
        super(TYPE);
        this.lineStrings = lineStrings;
    }

    public GeoMultiLineString(GeoLineString firstLineString, GeoLineString ... additionalLineStrings) {
        super(TYPE);
        Contracts.assertNotNull((Object)firstLineString, (String)"firstLineString");
        Contracts.assertNotNull((Object)additionalLineStrings, (String)"additionalLineStrings");
        this.lineStrings = new ArrayList<Object>(Arrays.asList(ArrayHelper.concat((Object)firstLineString, (Object[])additionalLineStrings)));
    }

    public List<GeoLineString> getLineStrings() {
        return this.lineStrings;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoMultiLineString that = (GeoMultiLineString)obj;
        return that.lineStrings.equals(this.lineStrings);
    }

    @Override
    protected BsonArray toCoordinates() {
        BsonArray coordinates = new BsonArray();
        for (GeoLineString geoLineString : this.lineStrings) {
            coordinates.add((BsonValue)geoLineString.toCoordinates());
        }
        return coordinates;
    }

    public static GeoMultiLineString fromDocument(Document document) {
        if (document == null) {
            return null;
        }
        GeoMultiLineString.checkType(TYPE, document);
        List linesCoordinates = (List)document.get((Object)"coordinates");
        if (linesCoordinates == null) {
            return null;
        }
        List<GeoLineString> geoLineStrings = linesCoordinates.stream().map(GeoLineString::fromCoordinates).collect(Collectors.toList());
        return new GeoMultiLineString(geoLineStrings);
    }

    public int hashCode() {
        return this.lineStrings.hashCode();
    }

    public String toString() {
        return "GeoMultiLineString [lineStrings=" + this.lineStrings + "]";
    }
}

