/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.ogm.datastore.neo4j.spi.GraphDatabaseServiceFactory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class EmbeddedGraphDatabaseFactory
implements GraphDatabaseServiceFactory {
    private String dbLocation;
    private String configurationLocation;
    private Properties configuration;

    @Override
    public void initialize(Properties properties) {
        this.validate(properties);
        this.dbLocation = properties.getProperty("hibernate.ogm.neo4j.database.path");
        this.configurationLocation = properties.getProperty("hibernate.ogm.neo4j.properties.location");
        this.configuration = properties;
    }

    private void validate(Properties properties) {
        String dbLocation = (String)properties.get("hibernate.ogm.neo4j.database.path");
        if (dbLocation == null) {
            throw new IllegalArgumentException("Property hibernate.ogm.neo4j.database.path cannot be null");
        }
    }

    @Override
    public GraphDatabaseService create() {
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.dbLocation);
        this.setConfigurationFromLocation(builder, this.configurationLocation);
        this.setConfigurationFromProperties(builder, this.configuration);
        return builder.newGraphDatabase();
    }

    private void setConfigurationFromProperties(GraphDatabaseBuilder builder, Properties properties) {
        if (properties != null) {
            builder.setConfig(this.convert(properties));
        }
    }

    private Map<String, String> convert(Properties properties) {
        HashMap<String, String> neo4jConfiguration = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            neo4jConfiguration.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return neo4jConfiguration;
    }

    private void setConfigurationFromLocation(GraphDatabaseBuilder builder, String cfgLocation) {
        if (cfgLocation != null) {
            try {
                builder.loadPropertiesFromURL(new URL(cfgLocation));
            }
            catch (MalformedURLException e) {
                builder.loadPropertiesFromFile(cfgLocation);
            }
        }
    }
}

