/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.neo4j;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;

public class Neo4jIndexManager {
    private static final String TABLE_PROPERTY = "_table";
    private static final String RELATIONSHIP_TYPE = "_relationship_type";
    private final Neo4jDatastoreProvider provider;

    public Neo4jIndexManager(Neo4jDatastoreProvider provider) {
        this.provider = provider;
    }

    public void index(Node node, EntityKey entityKey) {
        Index<Node> nodeIndex = this.provider.getNodesIndex();
        nodeIndex.add((PropertyContainer)node, TABLE_PROPERTY, (Object)entityKey.getTable());
        for (int i = 0; i < entityKey.getColumnNames().length; ++i) {
            nodeIndex.add((PropertyContainer)node, entityKey.getColumnNames()[i], entityKey.getColumnValues()[i]);
        }
    }

    private Map<String, Object> properties(EntityKey entitykey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(TABLE_PROPERTY, entitykey.getTable());
        for (int j = 0; j < entitykey.getColumnNames().length; ++j) {
            properties.put(entitykey.getColumnNames()[j], entitykey.getColumnValues()[j]);
        }
        return properties;
    }

    public void index(Relationship relationship) {
        Index<Relationship> relationshipIndex = this.provider.getRelationshipsIndex();
        relationshipIndex.add((PropertyContainer)relationship, RELATIONSHIP_TYPE, (Object)relationship.getType().name());
        for (String key : relationship.getPropertyKeys()) {
            relationshipIndex.add((PropertyContainer)relationship, key, relationship.getProperty(key));
        }
    }

    public void remove(Relationship rel) {
        Index<Relationship> relationshipIndex = this.provider.getRelationshipsIndex();
        relationshipIndex.remove((PropertyContainer)rel);
    }

    public Relationship findRelationship(RelationshipType type, RowKey rowKey) {
        String query = this.createQuery(this.properties(type, rowKey));
        Index<Relationship> relationshipIndex = this.provider.getRelationshipsIndex();
        return (Relationship)relationshipIndex.query((Object)query).getSingle();
    }

    private Map<String, Object> properties(RelationshipType type, RowKey rowKey) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(RELATIONSHIP_TYPE, type.name());
        for (int i = 0; i < rowKey.getColumnNames().length; ++i) {
            properties.put(rowKey.getColumnNames()[i], rowKey.getColumnValues()[i]);
        }
        return properties;
    }

    public Node findNode(EntityKey entityKey) {
        String query = this.createQuery(this.properties(entityKey));
        Index<Node> nodeIndex = this.provider.getNodesIndex();
        return (Node)nodeIndex.query((Object)query).getSingle();
    }

    private String createQuery(Map<String, Object> properties) {
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            queryBuilder.append(" AND ");
            this.appendTerm(queryBuilder, entry.getKey(), entry.getValue());
        }
        return queryBuilder.substring(" AND ".length());
    }

    private void appendTerm(StringBuilder queryBuilder, String key, Object value) {
        queryBuilder.append(key);
        queryBuilder.append(": \"");
        queryBuilder.append(value);
        queryBuilder.append("\"");
    }

    public void remove(Node entityNode) {
        Index<Node> nodeIndex = this.provider.getNodesIndex();
        nodeIndex.remove((PropertyContainer)entityNode);
    }

    public IndexHits<Node> findNodes(String tableName) {
        Index<Node> nodeIndex = this.provider.getNodesIndex();
        return nodeIndex.get(TABLE_PROPERTY, (Object)tableName);
    }
}

