/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.ast.spi.predicate.ConjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.DisjunctionPredicate;
import org.hibernate.hql.ast.spi.predicate.InPredicate;
import org.hibernate.hql.ast.spi.predicate.IsNullPredicate;
import org.hibernate.hql.ast.spi.predicate.LikePredicate;
import org.hibernate.hql.ast.spi.predicate.NegationPredicate;
import org.hibernate.hql.ast.spi.predicate.PredicateFactory;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.hql.ast.spi.predicate.RootPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jPropertyHelper;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.Neo4jQueryResolverDelegate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jComparisonPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jConjunctionPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jDisjunctionPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jInPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jIsNullPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jLikePredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jNegationPredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jRangePredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl.Neo4jRootPredicate;

public class Neo4jPredicateFactory
implements PredicateFactory<StringBuilder> {
    private final Neo4jPropertyHelper propertyHelper;
    private final Neo4jQueryResolverDelegate resolverDelegate;
    private final StringBuilder builder;

    public Neo4jPredicateFactory(Neo4jPropertyHelper propertyHelper, Neo4jQueryResolverDelegate resolverDelegate) {
        this.propertyHelper = propertyHelper;
        this.resolverDelegate = resolverDelegate;
        this.builder = new StringBuilder();
    }

    public RootPredicate<StringBuilder> getRootPredicate(String entityType) {
        return new Neo4jRootPredicate();
    }

    public ComparisonPredicate<StringBuilder> getComparisonPredicate(String entityType, ComparisonPredicate.Type comparisonType, List<String> propertyPath, Object value) {
        String columnName = this.columnName(entityType, propertyPath);
        String alias = this.alias(entityType);
        Object neo4jValue = this.propertyHelper.convertToLiteral(entityType, propertyPath, value);
        return new Neo4jComparisonPredicate(this.builder, alias, columnName, comparisonType, neo4jValue);
    }

    public DisjunctionPredicate<StringBuilder> getDisjunctionPredicate() {
        return new Neo4jDisjunctionPredicate(this.builder);
    }

    public ConjunctionPredicate<StringBuilder> getConjunctionPredicate() {
        return new Neo4jConjunctionPredicate(this.builder);
    }

    public InPredicate<StringBuilder> getInPredicate(String entityType, List<String> propertyPath, List<Object> typedElements) {
        String propertyName = this.columnName(entityType, propertyPath);
        String alias = this.alias(entityType);
        ArrayList<Object> gridTypedElements = new ArrayList<Object>(typedElements.size());
        for (Object typedElement : typedElements) {
            gridTypedElements.add(this.propertyHelper.convertToLiteral(entityType, propertyPath, typedElement));
        }
        return new Neo4jInPredicate(this.builder, alias, propertyName, gridTypedElements);
    }

    public RangePredicate<StringBuilder> getRangePredicate(String entityType, List<String> propertyPath, Object lowerValue, Object upperValue) {
        String propertyName = this.columnName(entityType, propertyPath);
        String alias = this.alias(entityType);
        Object neo4jLowerValue = this.propertyHelper.convertToLiteral(entityType, propertyPath, lowerValue);
        Object neo4jUpperValue = this.propertyHelper.convertToLiteral(entityType, propertyPath, upperValue);
        return new Neo4jRangePredicate(this.builder, alias, propertyName, neo4jLowerValue, neo4jUpperValue);
    }

    public NegationPredicate<StringBuilder> getNegationPredicate() {
        return new Neo4jNegationPredicate(this.builder);
    }

    public LikePredicate<StringBuilder> getLikePredicate(String entityType, List<String> propertyPath, String patternValue, Character escapeCharacter) {
        String propertyName = this.columnName(entityType, propertyPath);
        String alias = this.alias(entityType);
        return new Neo4jLikePredicate(this.builder, alias, propertyName, patternValue, escapeCharacter);
    }

    public IsNullPredicate<StringBuilder> getIsNullPredicate(String entityType, List<String> propertyPath) {
        String propertyName = this.columnName(entityType, propertyPath);
        String alias = this.alias(entityType);
        return new Neo4jIsNullPredicate(this.builder, alias, propertyName);
    }

    private String alias(String entityType) {
        return this.resolverDelegate.findAliasForType(entityType);
    }

    private String columnName(String entityType, List<String> propertyPath) {
        return this.propertyHelper.getColumnName(entityType, propertyPath.get(propertyPath.size() - 1));
    }
}

