/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.AssertionFailure;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.MapsTupleIterator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jAssociationQueries;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jAssociationSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jEntityQueries;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jSequenceGenerator;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTupleSnapshot;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.Neo4jTypeConverter;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodesTupleIterator;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.datastore.neo4j.impl.StringLoggerToJBossLoggingAdaptor;
import org.hibernate.ogm.datastore.neo4j.logging.impl.GraphLogger;
import org.hibernate.ogm.datastore.neo4j.logging.impl.Log;
import org.hibernate.ogm.datastore.neo4j.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.neo4j.query.impl.Neo4jParameterMetadataBuilder;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;
import org.hibernate.ogm.dialect.query.spi.BackendQuery;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.query.spi.QueryableGridDialect;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.SessionFactoryLifecycleAwareDialect;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.ArrayHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.Type;
import org.neo4j.cypher.CypherExecutionException;
import org.neo4j.cypher.javacompat.ExecutionEngine;
import org.neo4j.cypher.javacompat.ExecutionResult;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.exceptions.schema.UniqueConstraintViolationKernelException;
import org.neo4j.kernel.impl.util.StringLogger;

public class Neo4jDialect
extends BaseGridDialect
implements QueryableGridDialect<String>,
ServiceRegistryAwareService,
SessionFactoryLifecycleAwareDialect {
    private static final Pattern EMBEDDED_FIELDNAME_SEPARATOR = Pattern.compile("\\.");
    private static final String PROPERTY_SEPARATOR = ".";
    private static final Log log = LoggerFactory.getLogger();
    private final Neo4jSequenceGenerator neo4jSequenceGenerator;
    private ServiceRegistryImplementor serviceRegistry;
    private Map<EntityKeyMetadata, Neo4jEntityQueries> entityQueries;
    private Map<AssociationKeyMetadata, Neo4jAssociationQueries> associationQueries;
    private final ExecutionEngine executionEngine;

    public Neo4jDialect(Neo4jDatastoreProvider provider) {
        GraphDatabaseService dataBase = provider.getDataBase();
        StringLogger logger2 = this.getStringLogger(dataBase);
        this.executionEngine = new ExecutionEngine(dataBase, logger2);
        this.neo4jSequenceGenerator = provider.getSequenceGenerator();
    }

    private StringLogger getStringLogger(GraphDatabaseService dataBase) {
        StringLogger logger2 = null;
        if (dataBase instanceof GraphDatabaseAPI) {
            try {
                logger2 = (StringLogger)((GraphDatabaseAPI)dataBase).getDependencyResolver().resolveDependency(StringLogger.class);
                log.trace("Using same StringLogger between GraphDatabaseService and ExecutionEngine");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (logger2 == null) {
            logger2 = StringLoggerToJBossLoggingAdaptor.JBOSS_LOGGING_STRING_LOGGER;
            log.trace("Using StringLogger mapping to JBoss Logging");
        }
        return logger2;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void sessionFactoryCreated(SessionFactoryImplementor sessionFactoryImplementor) {
        this.associationQueries = Collections.unmodifiableMap(this.initializeAssociationQueries(sessionFactoryImplementor));
        this.entityQueries = Collections.unmodifiableMap(this.initializeEntityQueries(sessionFactoryImplementor, this.associationQueries));
    }

    private Map<EntityKeyMetadata, Neo4jEntityQueries> initializeEntityQueries(SessionFactoryImplementor sessionFactoryImplementor, Map<AssociationKeyMetadata, Neo4jAssociationQueries> associationQueries) {
        Map<EntityKeyMetadata, Neo4jEntityQueries> entityQueries = this.initializeEntityQueries(sessionFactoryImplementor);
        for (AssociationKeyMetadata associationKeyMetadata : associationQueries.keySet()) {
            EntityKeyMetadata entityKeyMetadata = associationKeyMetadata.getAssociatedEntityKeyMetadata().getEntityKeyMetadata();
            if (entityQueries.containsKey(entityKeyMetadata)) continue;
            entityQueries.put(entityKeyMetadata, new Neo4jEntityQueries(entityKeyMetadata));
        }
        return entityQueries;
    }

    private Map<EntityKeyMetadata, Neo4jEntityQueries> initializeEntityQueries(SessionFactoryImplementor sessionFactoryImplementor) {
        HashMap<EntityKeyMetadata, Neo4jEntityQueries> queryMap = new HashMap<EntityKeyMetadata, Neo4jEntityQueries>();
        Collection entityPersisters = sessionFactoryImplementor.getEntityPersisters().values();
        for (EntityPersister entityPersister : entityPersisters) {
            if (!(entityPersister instanceof OgmEntityPersister)) continue;
            OgmEntityPersister ogmEntityPersister = (OgmEntityPersister)entityPersister;
            queryMap.put(ogmEntityPersister.getEntityKeyMetadata(), new Neo4jEntityQueries(ogmEntityPersister.getEntityKeyMetadata()));
        }
        return queryMap;
    }

    private Map<AssociationKeyMetadata, Neo4jAssociationQueries> initializeAssociationQueries(SessionFactoryImplementor sessionFactoryImplementor) {
        HashMap<AssociationKeyMetadata, Neo4jAssociationQueries> queryMap = new HashMap<AssociationKeyMetadata, Neo4jAssociationQueries>();
        Collection collectionPersisters = sessionFactoryImplementor.getCollectionPersisters().values();
        for (CollectionPersister collectionPersister : collectionPersisters) {
            if (!(collectionPersister instanceof OgmCollectionPersister)) continue;
            OgmCollectionPersister ogmCollectionPersister = (OgmCollectionPersister)collectionPersister;
            EntityKeyMetadata ownerEntityKeyMetadata = ((OgmEntityPersister)ogmCollectionPersister.getOwnerEntityPersister()).getEntityKeyMetadata();
            AssociationKeyMetadata associationKeyMetadata = ogmCollectionPersister.getAssociationKeyMetadata();
            queryMap.put(associationKeyMetadata, new Neo4jAssociationQueries(ownerEntityKeyMetadata, associationKeyMetadata));
        }
        return queryMap;
    }

    public Tuple getTuple(EntityKey key, TupleContext context) {
        Node entityNode = this.entityQueries.get(key.getMetadata()).findEntity(this.executionEngine, key.getColumnValues());
        if (entityNode == null) {
            return null;
        }
        return new Tuple((TupleSnapshot)new Neo4jTupleSnapshot(entityNode, context.getAllAssociatedEntityKeyMetadata(), context.getAllRoles(), key.getMetadata()));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return new Tuple();
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        if (tuple.getSnapshot() instanceof EmptyTupleSnapshot) {
            Node node = this.insertTuple(key, tuple);
            this.applyTupleOperations(key, tuple, node, tuple.getOperations(), tupleContext);
            GraphLogger.log("Inserted node: %1$s", node);
        } else {
            Node node = ((Neo4jTupleSnapshot)tuple.getSnapshot()).getNode();
            this.applyTupleOperations(key, tuple, node, tuple.getOperations(), tupleContext);
            GraphLogger.log("Updated node: %1$s", node);
        }
    }

    private Node insertTuple(EntityKey key, Tuple tuple) {
        try {
            return this.entityQueries.get(key.getMetadata()).insertEntity(this.executionEngine, key.getColumnValues());
        }
        catch (CypherExecutionException cee) {
            if (cee.getCause() instanceof UniqueConstraintViolationKernelException) {
                throw new TupleAlreadyExistsException(key.getMetadata(), tuple, (Throwable)cee);
            }
            throw cee;
        }
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.entityQueries.get(key.getMetadata()).removeEntity(this.executionEngine, key.getColumnValues());
    }

    private Relationship createRelationship(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        switch (associationKey.getMetadata().getAssociationKind()) {
            case EMBEDDED_COLLECTION: {
                return this.createRelationshipWithEmbeddedNode(associationKey, associationRow, associatedEntityKeyMetadata);
            }
            case ASSOCIATION: {
                return this.findOrCreateRelationshipWithEntityNode(associationKey, associationRow, associatedEntityKeyMetadata);
            }
        }
        throw new AssertionFailure("Unrecognized associationKind: " + associationKey.getMetadata().getAssociationKind());
    }

    private Relationship createRelationshipWithEmbeddedNode(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        EntityKey entityKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Node embeddedNode = this.entityQueries.get(entityKey.getMetadata()).createEmbedded(this.executionEngine, entityKey.getColumnValues());
        Relationship relationship = this.createRelationshipWithTargetNode(associationKey, associationRow, embeddedNode);
        this.applyProperties(associationKey, associationRow, relationship);
        return relationship;
    }

    private Relationship findOrCreateRelationshipWithEntityNode(AssociationKey associationKey, Tuple associationRow, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        EntityKey targetEntityKey = this.getEntityKey(associationRow, associatedEntityKeyMetadata);
        Node targetNode = this.entityQueries.get(targetEntityKey.getMetadata()).findEntity(this.executionEngine, targetEntityKey.getColumnValues());
        return this.createRelationshipWithTargetNode(associationKey, associationRow, targetNode);
    }

    private void applyProperties(AssociationKey associationKey, Tuple associationRow, Relationship relationship) {
        String[] indexColumns = associationKey.getMetadata().getRowKeyIndexColumnNames();
        for (int i = 0; i < indexColumns.length; ++i) {
            String propertyName = indexColumns[i];
            Object propertyValue = associationRow.get(propertyName);
            relationship.setProperty(propertyName, propertyValue);
        }
    }

    private Relationship createRelationshipWithTargetNode(AssociationKey associationKey, Tuple associationRow, Node targetNode) {
        EntityKey entityKey = associationKey.getEntityKey();
        Node ownerNode = this.entityQueries.get(entityKey.getMetadata()).findEntity(this.executionEngine, entityKey.getColumnValues());
        Relationship relationship = ownerNode.createRelationshipTo(targetNode, (RelationshipType)DynamicRelationshipType.withName((String)associationKey.getMetadata().getCollectionRole()));
        this.applyProperties(associationKey, associationRow, relationship);
        return relationship;
    }

    public Association getAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        EntityKey entityKey = associationKey.getEntityKey();
        Node entityNode = this.entityQueries.get(entityKey.getMetadata()).findEntity(this.executionEngine, entityKey.getColumnValues());
        GraphLogger.log("Found owner node: %1$s", entityNode);
        if (entityNode == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new Neo4jAssociationSnapshot(entityNode, associationKey, associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata(), associationContext.getAssociationTypeContext().getRoleOnMainSide()));
    }

    public Association createAssociation(AssociationKey associationKey, AssociationContext associationContext) {
        return new Association();
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        for (AssociationOperation action : association.getOperations()) {
            this.applyAssociationOperation(association, key, action, associationContext);
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public Number nextValue(NextValueRequest request) {
        return this.neo4jSequenceGenerator.nextValue(request.getKey(), request.getIncrement(), request.getInitialValue());
    }

    public boolean supportsSequences() {
        return true;
    }

    public GridType overrideType(Type type) {
        return Neo4jTypeConverter.INSTANCE.convert(type);
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (key.getMetadata().isInverse()) {
            return;
        }
        this.associationQueries.get(key.getMetadata()).removeAssociation(this.executionEngine, key);
    }

    private void applyAssociationOperation(Association association, AssociationKey key, AssociationOperation operation, AssociationContext associationContext) {
        switch (operation.getType()) {
            case CLEAR: {
                this.removeAssociation(key, associationContext);
                break;
            }
            case PUT: {
                this.putAssociationOperation(association, key, operation, associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata());
                break;
            }
            case REMOVE: {
                this.removeAssociationOperation(association, key, operation, associationContext.getAssociationTypeContext().getAssociatedEntityKeyMetadata());
            }
        }
    }

    private void putAssociationOperation(Association association, AssociationKey associationKey, AssociationOperation action, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        Relationship relationship = this.associationQueries.get(associationKey.getMetadata()).findRelationship(this.executionEngine, associationKey, action.getKey());
        if (relationship != null) {
            for (String relationshipProperty : associationKey.getMetadata().getRowKeyIndexColumnNames()) {
                relationship.setProperty(relationshipProperty, action.getValue().get(relationshipProperty));
            }
            GraphLogger.log("Updated relationship: %1$s", relationship);
        } else {
            relationship = this.createRelationship(associationKey, action.getValue(), associatedEntityKeyMetadata);
            GraphLogger.log("Created relationship: %1$s", relationship);
        }
    }

    private void removeAssociationOperation(Association association, AssociationKey associationKey, AssociationOperation action, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        this.associationQueries.get(associationKey.getMetadata()).removeAssociationRow(this.executionEngine, associationKey, action.getKey());
    }

    private void applyTupleOperations(EntityKey entityKey, Tuple tuple, Node node, Set<TupleOperation> operations, TupleContext tupleContext) {
        HashSet<String> processedAssociationRoles = new HashSet<String>();
        for (TupleOperation operation : operations) {
            this.applyOperation(entityKey, tuple, node, operation, tupleContext, processedAssociationRoles);
        }
    }

    private void applyOperation(EntityKey entityKey, Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        switch (operation.getType()) {
            case PUT: {
                this.putTupleOperation(entityKey, tuple, node, operation, tupleContext, processedAssociationRoles);
                break;
            }
            case PUT_NULL: 
            case REMOVE: {
                this.removeTupleOperation(entityKey, node, operation, tupleContext, processedAssociationRoles);
            }
        }
    }

    private void removeTupleOperation(EntityKey entityKey, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (!tupleContext.isPartOfAssociation(operation.getColumn())) {
            if (Neo4jDialect.isPartOfRegularEmbedded(entityKey.getColumnNames(), operation.getColumn())) {
                String[] split = EMBEDDED_FIELDNAME_SEPARATOR.split(operation.getColumn());
                this.removePropertyForEmbedded(node, split, 0);
            } else if (node.hasProperty(operation.getColumn())) {
                node.removeProperty(operation.getColumn());
            }
        } else {
            Iterator relationships;
            String associationRole = tupleContext.getRole(operation.getColumn());
            if (!processedAssociationRoles.contains(associationRole) && (relationships = node.getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)associationRole)}).iterator()).hasNext()) {
                ((Relationship)relationships.next()).delete();
            }
        }
    }

    private void removePropertyForEmbedded(Node embeddedNode, String[] embeddedColumnSplit, int i) {
        Iterator iterator;
        if (i == embeddedColumnSplit.length - 1) {
            String property = embeddedColumnSplit[embeddedColumnSplit.length - 1];
            if (embeddedNode.hasProperty(property)) {
                embeddedNode.removeProperty(property);
            }
        } else {
            iterator = embeddedNode.getRelationships(Direction.OUTGOING, new RelationshipType[]{DynamicRelationshipType.withName((String)embeddedColumnSplit[i])}).iterator();
            if (iterator.hasNext()) {
                this.removePropertyForEmbedded(((Relationship)iterator.next()).getEndNode(), embeddedColumnSplit, i + 1);
            }
        }
        if (!embeddedNode.getPropertyKeys().iterator().hasNext() && (iterator = embeddedNode.getRelationships().iterator()).hasNext()) {
            Relationship relationship = (Relationship)iterator.next();
            if (!iterator.hasNext()) {
                relationship.delete();
                embeddedNode.delete();
            }
        }
    }

    private void putTupleOperation(EntityKey entityKey, Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        if (tupleContext.isPartOfAssociation(operation.getColumn())) {
            this.putOneToOneAssociation(tuple, node, operation, tupleContext, processedAssociationRoles);
        } else if (Neo4jDialect.isPartOfRegularEmbedded(entityKey.getMetadata().getColumnNames(), operation.getColumn())) {
            this.entityQueries.get(entityKey.getMetadata()).updateEmbeddedColumn(this.executionEngine, entityKey.getColumnValues(), operation.getColumn(), operation.getValue());
        } else {
            this.putProperty(entityKey, node, operation);
        }
    }

    public static boolean isPartOfRegularEmbedded(String[] keyColumnNames, String column) {
        return column.contains(PROPERTY_SEPARATOR) && !ArrayHelper.contains((Object[])keyColumnNames, (Object)column);
    }

    private void putProperty(EntityKey entityKey, Node node, TupleOperation operation) {
        try {
            node.setProperty(operation.getColumn(), operation.getValue());
        }
        catch (ConstraintViolationException e) {
            throw log.constraintViolation(entityKey, operation, (Exception)((Object)e));
        }
    }

    private void putOneToOneAssociation(Tuple tuple, Node node, TupleOperation operation, TupleContext tupleContext, Set<String> processedAssociationRoles) {
        String associationRole = tupleContext.getRole(operation.getColumn());
        if (!processedAssociationRoles.contains(associationRole)) {
            processedAssociationRoles.add(associationRole);
            EntityKey targetKey = this.getEntityKey(tuple, tupleContext.getAssociatedEntityKeyMetadata(operation.getColumn()));
            Iterator relationships = node.getRelationships(new RelationshipType[]{DynamicRelationshipType.withName((String)associationRole)}).iterator();
            if (relationships.hasNext()) {
                ((Relationship)relationships.next()).delete();
            }
            Node targetNode = this.entityQueries.get(targetKey.getMetadata()).findEntity(this.executionEngine, targetKey.getColumnValues());
            node.createRelationshipTo(targetNode, (RelationshipType)DynamicRelationshipType.withName((String)associationRole));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            try (ResourceIterator<Node> queryNodes = this.entityQueries.get(entityKeyMetadata).findEntities(this.executionEngine);){
                while (queryNodes.hasNext()) {
                    Node next = (Node)queryNodes.next();
                    Tuple tuple = new Tuple((TupleSnapshot)new Neo4jTupleSnapshot(next, entityKeyMetadata));
                    consumer.consume(tuple);
                }
            }
        }
    }

    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<String> backendQuery, QueryParameters queryParameters) {
        Map<String, Object> parameters = this.getNamedParameterValuesConvertedByGridType(queryParameters);
        String nativeQuery = this.buildNativeQuery(backendQuery, queryParameters);
        ExecutionResult result = this.executionEngine.execute(nativeQuery, parameters);
        if (backendQuery.getSingleEntityKeyMetadataOrNull() != null) {
            return new NodesTupleIterator(result, backendQuery.getSingleEntityKeyMetadataOrNull());
        }
        return new MapsTupleIterator(result);
    }

    public String parseNativeQuery(String nativeQuery) {
        return nativeQuery;
    }

    private String buildNativeQuery(BackendQuery<String> customQuery, QueryParameters queryParameters) {
        StringBuilder nativeQuery = new StringBuilder((String)customQuery.getQuery());
        this.applyFirstRow(queryParameters, nativeQuery);
        this.applyMaxRows(queryParameters, nativeQuery);
        return nativeQuery.toString();
    }

    private void applyFirstRow(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer firstRow = queryParameters.getRowSelection().getFirstRow();
        if (firstRow != null) {
            CypherDSL.skip(nativeQuery, firstRow);
        }
    }

    private void applyMaxRows(QueryParameters queryParameters, StringBuilder nativeQuery) {
        Integer maxRows = queryParameters.getRowSelection().getMaxRows();
        if (maxRows != null) {
            CypherDSL.limit(nativeQuery, maxRows);
        }
    }

    private Map<String, Object> getNamedParameterValuesConvertedByGridType(QueryParameters queryParameters) {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>(queryParameters.getNamedParameters().size());
        Tuple dummy = new Tuple();
        TypeTranslator typeTranslator = (TypeTranslator)this.serviceRegistry.getService(TypeTranslator.class);
        for (Map.Entry parameter : queryParameters.getNamedParameters().entrySet()) {
            GridType gridType = typeTranslator.getType(((TypedValue)parameter.getValue()).getType());
            gridType.nullSafeSet(dummy, ((TypedValue)parameter.getValue()).getValue(), new String[]{(String)parameter.getKey()}, null);
            parameterValues.put((String)parameter.getKey(), dummy.get((String)parameter.getKey()));
        }
        return parameterValues;
    }

    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return new Neo4jParameterMetadataBuilder();
    }

    private EntityKey getEntityKey(Tuple tuple, AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
        Object[] columnValues = new Object[associatedEntityKeyMetadata.getAssociationKeyColumns().length];
        int i = 0;
        for (String associationKeyColumn : associatedEntityKeyMetadata.getAssociationKeyColumns()) {
            columnValues[i] = tuple.get(associationKeyColumn);
            ++i;
        }
        return new EntityKey(associatedEntityKeyMetadata.getEntityKeyMetadata(), columnValues);
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return entityKeyMetadata.getColumnNames().length == 1 ? DuplicateInsertPreventionStrategy.NATIVE : DuplicateInsertPreventionStrategy.LOOK_UP;
    }
}

