/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.query.parsing.impl.predicate.impl;

import org.hibernate.hql.ast.spi.predicate.NegatablePredicate;
import org.hibernate.hql.ast.spi.predicate.RangePredicate;
import org.hibernate.ogm.datastore.neo4j.query.parsing.cypherdsl.impl.CypherDSL;

public class Neo4jRangePredicate
extends RangePredicate<StringBuilder>
implements NegatablePredicate<StringBuilder> {
    private final String alias;
    private final StringBuilder builder;

    public Neo4jRangePredicate(StringBuilder builder, String alias, String propertyName, Object lower, Object upper) {
        super(propertyName, lower, upper);
        this.builder = builder;
        this.alias = alias;
    }

    public StringBuilder getQuery() {
        this.comparator(" >= ", this.lower);
        this.builder.append(" AND ");
        this.comparator(" <= ", this.upper);
        return this.builder;
    }

    public StringBuilder getNegatedQuery() {
        this.comparator(" < ", this.lower);
        this.builder.append(" OR ");
        this.comparator(" > ", this.upper);
        return this.builder;
    }

    private void comparator(String operator, Object value) {
        CypherDSL.identifier(this.builder, this.alias, this.propertyName);
        this.builder.append(operator);
        CypherDSL.literal(this.builder, value);
    }
}

