/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.dialect.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.ogm.datastore.neo4j.dialect.impl.NodeLabel;
import org.hibernate.ogm.id.spi.PersistentNoSqlIdentifierGenerator;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;

public class Neo4jSequenceGenerator {
    private static final String INITIAL_VALUE_QUERY_PARAM = "initialValue";
    private static final String SEQUENCE_NAME_QUERY_PARAM = "sequenceName";
    private static final String SEQUENCE_NAME_PROPERTY = "sequence_name";
    private static final String SEQUENCE_VALUE_PROPERTY = "next_val";
    private static final String SEQUENCE_CREATION_QUERY = "MERGE (n:" + NodeLabel.SEQUENCE.name() + " {" + "sequence_name" + ": {sequenceName}} ) ON CREATE SET n." + "next_val" + " = {initialValue} RETURN n";
    private static final String SEQUENCE_VALUE_QUERY = "MATCH (n:" + NodeLabel.SEQUENCE.name() + ") WHERE n." + "sequence_name" + " = {sequenceName} RETURN n";
    private final BoundedConcurrentHashMap<String, String> queryCache;
    private final GraphDatabaseService neo4jDb;

    public Neo4jSequenceGenerator(GraphDatabaseService neo4jDb, int sequenceCacheMaxSize) {
        this.neo4jDb = neo4jDb;
        this.queryCache = new BoundedConcurrentHashMap(sequenceCacheMaxSize, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public void createSequences(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        this.addUniqueConstraints(identifierGenerators);
        this.addSequences(identifierGenerators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUniqueConstraints(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        try (Transaction tx = null;){
            tx = this.neo4jDb.beginTx();
            for (PersistentNoSqlIdentifierGenerator identifierGenerator : identifierGenerators) {
                this.addUniqueConstraint(identifierGenerator);
            }
            tx.success();
        }
    }

    private void addUniqueConstraint(PersistentNoSqlIdentifierGenerator identifierGenerator) {
        if (identifierGenerator.getGeneratorKeyMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE) {
            this.addUniqueConstraintForSequence(identifierGenerator.getGeneratorKeyMetadata());
        }
        if (identifierGenerator.getGeneratorKeyMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE) {
            this.addUniqueConstraintForTableBasedSequence(identifierGenerator.getGeneratorKeyMetadata());
        }
    }

    private void addUniqueConstraintForSequence(IdSourceKeyMetadata idSourceKeyMetadata) {
        if (this.isMissingUniqueConstraint(NodeLabel.SEQUENCE)) {
            this.neo4jDb.schema().constraintFor((Label)NodeLabel.SEQUENCE).assertPropertyIsUnique(SEQUENCE_NAME_PROPERTY).create();
        }
    }

    private void addUniqueConstraintForTableBasedSequence(IdSourceKeyMetadata generatorKeyMetadata) {
        Label generatorKeyLabel = DynamicLabel.label((String)generatorKeyMetadata.getName());
        if (this.isMissingUniqueConstraint(generatorKeyLabel)) {
            this.neo4jDb.schema().constraintFor(generatorKeyLabel).assertPropertyIsUnique(generatorKeyMetadata.getKeyColumnName()).create();
        }
    }

    private boolean isMissingUniqueConstraint(Label generatorKeyLabel) {
        Iterable constraints = this.neo4jDb.schema().getConstraints(generatorKeyLabel);
        for (ConstraintDefinition constraint : constraints) {
            if (!constraint.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSequences(Set<PersistentNoSqlIdentifierGenerator> identifierGenerators) {
        try (Transaction tx = null;){
            tx = this.neo4jDb.beginTx();
            for (PersistentNoSqlIdentifierGenerator generator : identifierGenerators) {
                this.addSequence(generator);
            }
            tx.success();
        }
    }

    private void addSequence(PersistentNoSqlIdentifierGenerator identifierGenerator) {
        if (identifierGenerator.getGeneratorKeyMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE) {
            this.addSequence(identifierGenerator.getGeneratorKeyMetadata(), identifierGenerator.getInitialValue());
        }
    }

    private void addTableSequence(IdSourceKeyMetadata idSourceKeyMetadata, String sequenceName, int initialValue) {
        Label generatorKeyLabel = DynamicLabel.label((String)idSourceKeyMetadata.getName());
        String query = "MERGE (n" + this.labels(generatorKeyLabel.name(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + " { " + idSourceKeyMetadata.getKeyColumnName() + ": {" + SEQUENCE_NAME_QUERY_PARAM + "}} ) ON CREATE SET n." + idSourceKeyMetadata.getValueColumnName() + " = {" + INITIAL_VALUE_QUERY_PARAM + "} RETURN n";
        this.neo4jDb.execute(query, this.params(sequenceName, initialValue));
    }

    private void addSequence(IdSourceKeyMetadata idSourceKeyMetadata, int initialValue) {
        this.neo4jDb.execute(SEQUENCE_CREATION_QUERY, this.params(idSourceKeyMetadata.getName(), initialValue));
    }

    private Map<String, Object> params(String sequenceName, int initialValue) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put(INITIAL_VALUE_QUERY_PARAM, initialValue);
        params.put(SEQUENCE_NAME_QUERY_PARAM, sequenceName);
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextValue(IdSourceKey idSourceKey, int increment, int initialValue) {
        Lock lock = null;
        try (Transaction tx = this.neo4jDb.beginTx();){
            Node sequence = this.getSequence(idSourceKey);
            if (sequence == null) {
                if (idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE) {
                    throw new HibernateException("Sequence missing: " + idSourceKey.getMetadata().getName());
                }
                this.addTableSequence(idSourceKey.getMetadata(), (String)idSourceKey.getColumnValues()[0], initialValue);
                sequence = this.getSequence(idSourceKey);
            }
            lock = tx.acquireWriteLock((PropertyContainer)sequence);
            long nextValue = this.updateSequenceValue(idSourceKey, sequence, increment);
            tx.success();
            lock.release();
            long l = nextValue;
            return l;
        }
    }

    private Node getSequence(IdSourceKey idSourceKey) {
        String updateSequenceQuery = this.getQuery(idSourceKey);
        Result result = this.neo4jDb.execute(updateSequenceQuery, Collections.singletonMap(SEQUENCE_NAME_QUERY_PARAM, this.sequenceName(idSourceKey)));
        ResourceIterator column = result.columnAs("n");
        Node node = null;
        if (column.hasNext()) {
            node = (Node)column.next();
        }
        column.close();
        return node;
    }

    private String getQuery(IdSourceKey idSourceKey) {
        return idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? this.getTableQuery(idSourceKey) : SEQUENCE_VALUE_QUERY;
    }

    private String getTableQuery(IdSourceKey idSourceKey) {
        String query = (String)this.queryCache.get((Object)idSourceKey.getTable());
        if (query == null) {
            query = "MATCH (n" + this.labels(idSourceKey.getTable(), NodeLabel.TABLE_BASED_SEQUENCE.name()) + ") WHERE n." + idSourceKey.getMetadata().getKeyColumnName() + " = {" + SEQUENCE_NAME_QUERY_PARAM + "} RETURN n";
            String cached = (String)this.queryCache.putIfAbsent((Object)idSourceKey.getTable(), (Object)query);
            if (cached != null) {
                query = cached;
            }
        }
        return query;
    }

    private String labels(String ... labels) {
        StringBuilder builder = new StringBuilder();
        for (String label : labels) {
            builder.append(":`");
            builder.append(label);
            builder.append("`");
        }
        return builder.toString();
    }

    private String sequenceName(IdSourceKey key) {
        return key.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.SEQUENCE ? key.getMetadata().getName() : (String)key.getColumnValues()[0];
    }

    private long updateSequenceValue(IdSourceKey idSourceKey, Node sequence, int increment) {
        String valueProperty = idSourceKey.getMetadata().getType() == IdSourceKeyMetadata.IdSourceType.TABLE ? idSourceKey.getMetadata().getValueColumnName() : SEQUENCE_VALUE_PROPERTY;
        Number currentValue = (Number)sequence.getProperty(valueProperty);
        long updatedValue = currentValue.longValue() + (long)increment;
        sequence.setProperty(valueProperty, (Object)updatedValue);
        return currentValue.longValue();
    }
}

