/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.neo4j.transaction.impl;

import javax.transaction.Synchronization;
import org.hibernate.ogm.datastore.neo4j.impl.Neo4jDatastoreProvider;
import org.hibernate.ogm.transaction.impl.ForwardingTransactionCoordinator;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class Neo4jJtaTransactionCoordinator
extends ForwardingTransactionCoordinator {
    private final GraphDatabaseService graphDB;
    private Transaction tx = null;

    public Neo4jJtaTransactionCoordinator(TransactionCoordinator delegate, Neo4jDatastoreProvider graphDb) {
        super(delegate);
        this.graphDB = graphDb.getDataBase();
    }

    public void explicitJoin() {
        super.explicitJoin();
        this.join();
    }

    public void pulse() {
        super.pulse();
        this.join();
    }

    private void join() {
        if (this.tx == null && this.delegate.isActive()) {
            this.tx = this.graphDB.beginTx();
            this.delegate.getLocalSynchronizations().registerSynchronization((Synchronization)new Neo4jSynchronization());
        }
    }

    private void success() {
        if (this.tx != null) {
            this.tx.success();
            this.close();
        }
    }

    private void failure() {
        if (this.tx != null) {
            this.tx.failure();
            this.close();
        }
    }

    private void close() {
        try {
            this.tx.close();
        }
        finally {
            this.tx = null;
        }
    }

    private class Neo4jSynchronization
    implements Synchronization {
        private Neo4jSynchronization() {
        }

        public void beforeCompletion() {
            TransactionStatus status = Neo4jJtaTransactionCoordinator.this.delegate.getTransactionDriverControl().getStatus();
            if (status == TransactionStatus.MARKED_ROLLBACK) {
                Neo4jJtaTransactionCoordinator.this.failure();
            } else {
                Neo4jJtaTransactionCoordinator.this.success();
            }
        }

        public void afterCompletion(int status) {
            if (Neo4jJtaTransactionCoordinator.this.tx != null) {
                if (status != 3) {
                    Neo4jJtaTransactionCoordinator.this.failure();
                } else {
                    Neo4jJtaTransactionCoordinator.this.success();
                }
            }
        }
    }
}

